<?php
// File: app/Helpers/SettingHelper.php

if (!function_exists('app_setting')) {
    /**
     * Get/Set application settings from database
     * 
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    function app_setting(string $key, $default = null)
    {
        $setting = \DB::table('settings')->where('key', $key)->first();
        
        if ($setting) {
            return $setting->value;
        }
        
        return $default;
    }
}