<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class SettingsController extends Controller
{
    public function index(Request $request)
    {
        return $this->show($request);
    }

    public function show(Request $request)
    {
        try {
            // -------------------------
            // 1) Settings store values
            // -------------------------
            $get = function (string $key, $default = '') {
                try {
                    if (function_exists('setting')) {
                        return setting($key, $default);
                    }
                } catch (\Throwable $e) {}

                $cfg = config("settings.$key");
                return $cfg !== null ? $cfg : $default;
            };

            $androidShareUrl = (string) $get('android_share_url', '');
            $iosShareUrl     = (string) $get('ios_share_url', '');
            $androidAppVer   = (string) $get('android_app_version', '');
            $iosAppVer       = (string) $get('ios_app_version', '');

            // -------------------------
            // 2) Localized force update text/title from app_contents
            // key = force_update_text
            // -------------------------
            $langRaw = (string) $request->query('lang', 'en');
            $lang = strtolower(trim(explode('-', str_replace('_','-',$langRaw))[0]));
            if ($lang === '') $lang = 'en';

            $row = DB::table('app_contents')
                ->where('key', 'force_update_text')
                ->where('language_code', $lang)
                ->first();

            if (!$row) {
                $row = DB::table('app_contents')
                    ->where('key', 'force_update_text')
                    ->where('language_code', 'en')
                    ->first();
            }

            $forceTitle = $row?->title ? (string) $row->title : '';
            $forceText  = $row?->body  ? (string) $row->body  : '';

            return response()->json([
                'android_share_url'    => $androidShareUrl,
                'ios_share_url'        => $iosShareUrl,

                'force_update_title'   => $forceTitle,
                'force_update_text'    => $forceText,

                'android_app_version'  => $androidAppVer,
                'ios_app_version'      => $iosAppVer,
            ], 200);

        } catch (\Throwable $e) {
            Log::error('api/settings failed', [
                'message' => $e->getMessage(),
                'file'    => $e->getFile(),
                'line'    => $e->getLine(),
            ]);

            // ✅ never break the app
            return response()->json([
                'android_share_url'    => '',
                'ios_share_url'        => '',
                'force_update_title'   => '',
                'force_update_text'    => 'Temporary server issue. Please try again.',
                'android_app_version'  => '',
                'ios_app_version'      => '',
            ], 200);
        }
    }
}