<?php
// File: /home/okgroups/public_html/sm.okgroups.com/app/Http/Controllers/Api/Telemetry/DevicePingController.php

namespace App\Http\Controllers\Api\Telemetry;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\DevicePingRequest;
use App\Models\DeviceTelemetry;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;

class DevicePingController extends Controller
{
    public function ping(DevicePingRequest $request): JsonResponse
    {
        $data = $request->validated();

        // ✅ همسان‌سازی device_id با username
        $deviceId = $data['device_id'];
        if (!str_starts_with($deviceId, 'd_')) {
            $deviceId = 'd_' . $deviceId;
        }

        // server time is source of truth
        $now = isset($data['opened_at'])
            ? Carbon::parse($data['opened_at'])
            : now();

        $row = DeviceTelemetry::where('device_id', $deviceId)->first();

        if (!$row) {
            $row = new DeviceTelemetry();
            $row->device_id = $deviceId;
            $row->first_seen_at = $now;
            $row->open_count = 0;
        }

        // always update counters & last_seen
        $row->open_count = (int)($row->open_count ?? 0) + 1;
        $row->last_seen_at = $now;

        // locales can update every time
        if (array_key_exists('device_locale', $data)) {
            $row->device_locale = $this->normalizeLocale($data['device_locale']);
        }
        if (array_key_exists('app_locale', $data)) {
            $row->app_locale = $this->normalizeLocale($data['app_locale']);
        }

        // ✅ user_ip و country_code همیشه آپدیت شود
        if (array_key_exists('user_ip', $data) && !empty($data['user_ip'])) {
            $row->user_ip = $data['user_ip'];
        }
        if (array_key_exists('country_code', $data) && !empty($data['country_code'])) {
            $row->country_code = strtoupper($data['country_code']);
        }

        // store-once policy for device specs
        if (!$row->device_model && !empty($data['device_model'])) {
            $row->device_model = $data['device_model'];
        }
        if (!$row->os && !empty($data['os'])) {
            $row->os = $data['os'];
        }
        if (!$row->os_version && !empty($data['os_version'])) {
            $row->os_version = $data['os_version'];
        }
        if (!empty($data['app_version'])) {
            $row->app_version = $data['app_version'];
        }

        $row->save();

        return response()->json([
            'ok' => true,
            'open_count' => (int) $row->open_count,
            'last_seen' => optional($row->last_seen_at)->toISOString(),
        ]);
    }

    private function normalizeLocale(?string $value): ?string
    {
        if ($value === null) return null;

        $v = trim($value);

        if ($v === '' || strtolower($v) === 'none') {
            return '__unknown__';
        }

        $v = str_replace('_', '-', $v);
        $parts = explode('-', $v);
        $base = strtolower($parts[0] ?? $v);

        return $base ?: '__unknown__';
    }
}