<?php
// File: /home/okgroups/public_html/sm.okgroups.com/app/Http/Controllers/Web/SettingsController.php

namespace App\Http\Controllers\Web;

use App\Events\SettingsUpdated;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse;
use Setting;

class SettingsController extends Controller
{
    /**
     * General Settings page
     */
    public function general()
    {
        $settings = [
            'app_name'            => setting('app_name', ''),
            'android_share_url'   => setting('android_share_url', ''),
            'ios_share_url'       => setting('ios_share_url', ''),

            // ✅ Force update fields
            'force_update_text'   => setting('force_update_text', ''),
            'android_app_version' => setting('android_app_version', ''),
            'ios_app_version'     => setting('ios_app_version', ''),
            
            // ✅ Signup bonus
            'signup_bonus_minutes' => setting('signup_bonus_minutes', '3'),
        ];

        return view('settings.general', compact('settings'));
    }

    /**
     * Auth Settings page (existing view)
     */
    public function auth()
    {
        // این صفحه قبلاً وجو�� داشته؛
        // برای اینکه هیچ چیزی نشکنه، همه settings رو پاس می‌دیم
        $settings = Setting::all();

        return view('settings.auth', compact('settings'));
    }

    /**
     * Notifications Settings page (existing view)
     */
    public function notifications()
    {
        $settings = Setting::all();

        return view('settings.notifications', compact('settings'));
    }

    /**
     * ✅ Main update endpoint used by routes/web.php
     * This controller is shared across multiple settings pages.
     */
    public function update(Request $request): RedirectResponse
    {
        $request->validate([
            // General
            'app_name'          => ['sometimes', 'nullable', 'string', 'max:255'],
            'android_share_url' => ['sometimes', 'nullable', 'url', 'max:2048'],
            'ios_share_url'     => ['sometimes', 'nullable', 'url', 'max:2048'],

            // ✅ Force update (keep as string for SemVer like 1.2.3+45)
            'force_update_text'   => ['sometimes', 'nullable', 'string', 'max:5000'],
            'android_app_version' => ['sometimes', 'nullable', 'string', 'max:64'],
            'ios_app_version'     => ['sometimes', 'nullable', 'string', 'max:64'],
            
            // ✅ Signup bonus
            'signup_bonus_minutes' => ['sometimes', 'nullable', 'integer', 'min:0', 'max:1440'],
        ]);

        // فقط کلیدهایی که واقعاً داخل request هستند ذخیره شوند
        $payload = $request->except('_token');

        foreach ($payload as $key => $value) {
            // اگر خالی بود و nullable هست، خالی ذخیره می‌کنیم (طبق خواسته شما)
            Setting::set($key, $value ?? '');
        }

        Setting::save();

        // اگر جای دیگری listening دارید
        try {
            event(new SettingsUpdated());
        } catch (\Throwable $e) {
            // مهم نیست اگر event نبود یا مشکل داشت، ذخیره انجام شده
        }

        return back()->withSuccess(__('Settings updated successfully.'));
    }

    /**
     * Backward compatibility: اگر جایی route به updateGeneral می‌زد
     */
    public function updateGeneral(Request $request): RedirectResponse
    {
        return $this->update($request);
    }
}