<?php

namespace App\Http\Controllers\Web\Users;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

class UserCreditController extends Controller
{
    /**
     * Add minutes to user's credit.
     * Route: PUT users/{user}/credit/add
     */
    public function add(Request $request, User $user): RedirectResponse
    {
        $data = $request->validate([
            'minutes' => ['required', 'integer', 'min:1', 'max:1000000'],
        ]);

        $addSeconds = (int) $data['minutes'] * 60;

        $current = (int) ($user->credit_seconds ?? 0);
        $new = $current + $addSeconds;
        if ($new < 0) $new = 0;

        $user->forceFill([
            'credit_seconds' => $new,
            'credit_updated_at' => now(),
        ])->save();

        return back()->withSuccess("✅ Credit updated (+{$data['minutes']} min).");
    }

    /**
     * Set user's credit to exact minutes.
     * Route: PUT users/{user}/credit/set
     */
    public function set(Request $request, User $user): RedirectResponse
    {
        $data = $request->validate([
            'minutes' => ['required', 'integer', 'min:0', 'max:1000000'],
        ]);

        $seconds = (int) $data['minutes'] * 60;
        if ($seconds < 0) $seconds = 0;

        $user->forceFill([
            'credit_seconds' => $seconds,
            'credit_updated_at' => now(),
        ])->save();

        return back()->withSuccess("✅ Credit set (= {$data['minutes']} min).");
    }
}
