<?php
// File: /home/okgroups/public_html/sm.okgroups.com/app/Http/Requests/Api/DevicePingRequest.php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class DevicePingRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true; // public endpoint
    }

    public function rules(): array
    {
        return [
            'device_id'      => ['required', 'string', 'max:128'],

            'device_model'   => ['nullable', 'string', 'max:120'],
            'os'             => ['nullable', 'string', 'max:16'],
            'os_version'     => ['nullable', 'string', 'max:32'],
            'app_version'    => ['nullable', 'string', 'max:32'],

            'device_locale'  => ['nullable', 'string', 'max:16'],
            'app_locale'     => ['nullable', 'string', 'max:16'],

            'user_ip'        => ['nullable', 'string', 'max:45', 'ip'],
            'country_code'   => ['nullable', 'string', 'max:2'],

            'opened_at'      => ['nullable', 'date'],
        ];
    }
}