<?php
// File: /home/okgroups/public_html/sm.okgroups.com/app/Models/Purchase.php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Purchase extends Model
{
    protected $fillable = [
        'user_id',
        'device_id',
        'product_id',
        'receipt',
        'purchase_token',
        'seconds_added',
        'status',
        'fail_reason',
        'price',
        'currency',
        'ip',
        'user_agent',
        'purchased_at',
    ];

    protected $casts = [
        'purchased_at' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}