<?php
// File: /home/okgroups/public_html/sm.okgroups.com/app/Models/VoucherRedemption.php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VoucherRedemption extends Model
{
    protected $fillable = [
        'voucher_id',
        'code_snapshot',
        'user_id',
        'device_id',
        'status',
        'fail_reason',
        'redeemed_at',
        'ip',
        'user_agent',
    ];

    protected $casts = [
        'redeemed_at' => 'datetime',
    ];

    public function voucher(): BelongsTo
    {
        return $this->belongsTo(Voucher::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}