<?php

namespace App\Support\Plugins;

use Vanguard\Plugins\Plugin;
use App\Support\Sidebar\Item;

class RolesAndPermissions extends Plugin
{
    public function sidebar(): Item
    {
        $roles = Item::create(__('Roles'))
            ->route('roles.index')
            ->active('roles*')
            ->permissions('roles.manage');

        $permissions = Item::create(__('Permissions'))
            ->route('permissions.index')
            ->active('permissions*')
            ->permissions('permissions.manage');

        return Item::create(__('Roles & Permissions'))
            ->href('#roles-dropdown')
            ->icon('fas fa-users-cog')
            ->permissions(['roles.manage', 'permissions.manage'])
            ->addChildren([
                $roles,
                $permissions,
            ]);
    }
}
