<?php
// File: /home/okgroups/public_html/sm.okgroups.com/app/Support/Plugins/Settings.php

namespace App\Support\Plugins;

use App\Models\User;
use Vanguard\Plugins\Plugin;
use App\Support\Sidebar\Item;

class Settings extends Plugin
{
    public function sidebar(): Item
    {
        $general = Item::create(__('General'))
            ->route('settings.general')
            ->active('settings')
            ->permissions('settings.general');

        $authAndRegistration = Item::create(__('Auth & Registration'))
            ->route('settings.auth')
            ->active('settings/auth')
            ->permissions('settings.auth');

        $notifications = Item::create(__('Notifications'))
            ->route('settings.notifications')
            ->active('settings/notifications')
            ->permissions(function (User $user) {
                return $user->hasPermission('settings.notifications');
            });

        // ✅ NEW: App Contents
        $appContents = Item::create(__('App Contents'))
            ->route('settings.app_contents.index') // ✅ MUST match route:list
            ->active('settings/app-contents')
            ->permissions(function (User $user) {
                return $user->hasPermission('settings.general');
            });

        // ✅ NEW: Vouchers
        $vouchers = Item::create(__('Vouchers'))
            ->route('settings.vouchers.index')
            ->active('settings/vouchers')
            ->permissions(function (User $user) {
                return $user->hasPermission('settings.general');
            });

        return Item::create(__('Settings'))
            ->href('#settings-dropdown')
            ->icon('fas fa-cogs')
            ->permissions(function (User $user) {
                return $user->hasPermission(
                    ['settings.general', 'settings.auth', 'settings.notifications', 'settings.general'],
                    allRequired: false
                );
            })
            ->addChildren([
                $general,
                $authAndRegistration,
                $notifications,
                $appContents,
                $vouchers,
            ]);
    }
}
