<?php
// File: database/migrations/2026_02_06_xxxxxx_add_credit_seconds_to_users_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'credit_seconds')) {
                $table->unsignedInteger('credit_seconds')->default(0)->after('public_code');
            }
            if (!Schema::hasColumn('users', 'credit_updated_at')) {
                $table->timestamp('credit_updated_at')->nullable()->after('credit_seconds');
            }
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (Schema::hasColumn('users', 'credit_updated_at')) {
                $table->dropColumn('credit_updated_at');
            }
            if (Schema::hasColumn('users', 'credit_seconds')) {
                $table->dropColumn('credit_seconds');
            }
        });
    }
};
