// File: sm.okgroups.com/project_root/database/migrations/2026_02_09_000001_create_app_contents_table.php

<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('app_contents', function (Blueprint $table) {
            $table->id();

            // کلید ثابت (about, terms, privacy, version_popup, voucher_popup, ...)
            $table->string('key', 80)->unique();

            // عنوانی که در UI می‌بینی
            $table->string('title', 190);

            // متن/HTML
            $table->longText('body')->nullable();

            // plain | html | markdown (فعلاً html/ plain کافیه)
            $table->string('format', 20)->default('html');

            // فعال/غیرفعال
            $table->boolean('is_active')->default(true);

            // ایده خودت: تایید شده/نشده (ادمین بعداً verify کند)
            $table->boolean('is_verified')->default(true);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('app_contents');
    }
};
