<?php
// File: /home/okgroups/public_html/sm.okgroups.com/database/migrations/2026_02_09_000001_create_vouchers_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('vouchers', function (Blueprint $table) {
            $table->id();

            $table->string('code', 64)->unique();               // voucher code (uppercase recommended)
            $table->unsignedInteger('seconds')->default(0);     // credit seconds

            $table->decimal('price', 12, 3)->nullable();         // optional
            $table->string('title', 120)->nullable();            // optional label

            $table->unsignedInteger('max_uses')->default(1);     // default: one-time voucher
            $table->unsignedInteger('uses_count')->default(0);

            $table->boolean('is_active')->default(true);
            $table->timestamp('expires_at')->nullable();

            $table->unsignedBigInteger('created_by')->nullable(); // admin user id optional

            $table->timestamps();

            $table->index(['is_active', 'expires_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('vouchers');
    }
};
