<?php
// File: /home/okgroups/public_html/sm.okgroups.com/database/migrations/2026_02_09_000002_create_voucher_redemptions_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('voucher_redemptions', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('voucher_id')->nullable();
            $table->string('code_snapshot', 64); // store code used at redemption time

            $table->unsignedBigInteger('user_id')->nullable();
            $table->string('device_id', 128)->nullable();

            $table->enum('status', ['success', 'failed'])->index();
            $table->string('fail_reason', 40)->nullable(); // invalid/used/expired/inactive/...
            $table->timestamp('redeemed_at')->useCurrent();

            $table->string('ip', 45)->nullable();
            $table->string('user_agent', 255)->nullable();

            $table->timestamps();

            $table->index(['device_id', 'redeemed_at']);
            $table->index(['user_id', 'redeemed_at']);

            $table->foreign('voucher_id')->references('id')->on('vouchers')->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('voucher_redemptions');
    }
};
