<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchases', function (Blueprint $table) {
            $table->id();
            
            $table->unsignedInteger('user_id')->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('set null');
            
            $table->string('device_id', 128)->nullable();
            $table->string('product_id', 128);
            $table->longText('receipt');
            $table->string('purchase_token', 512)->nullable();
            $table->integer('seconds_added');
            $table->enum('status', ['pending', 'success', 'failed'])->default('pending');
            $table->string('fail_reason', 255)->nullable();
            $table->decimal('price', 10, 2)->nullable();
            $table->string('currency', 3)->default('USD');
            $table->ipAddress('ip')->nullable();
            $table->text('user_agent')->nullable();
            $table->timestamp('purchased_at')->nullable();
            $table->timestamps();
            
            $table->index('user_id');
            $table->index('device_id');
            $table->index('product_id');
            $table->index('status');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('purchases');
    }
};