<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('app_contents', function (Blueprint $table) {
            if (!Schema::hasColumn('app_contents', 'language_code')) {
                $table->string('language_code', 10)->default('en')->after('key');
            }
        });

        // indexes
        Schema::table('app_contents', function (Blueprint $table) {
            $table->unique(['key', 'language_code'], 'app_contents_key_lang_unique');
            $table->index(['key', 'language_code', 'is_active', 'is_verified'], 'app_contents_lookup');
        });
    }

    public function down(): void
    {
        Schema::table('app_contents', function (Blueprint $table) {
            $table->dropIndex('app_contents_lookup');
            $table->dropUnique('app_contents_key_lang_unique');

            if (Schema::hasColumn('app_contents', 'language_code')) {
                $table->dropColumn('language_code');
            }
        });
    }
};