<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('app_contents', function (Blueprint $table) {
            // Drop old unique index on `key` only
            // Index name seen in error: app_contents_key_unique
            $table->dropUnique('app_contents_key_unique');
        });
    }

    public function down(): void
    {
        Schema::table('app_contents', function (Blueprint $table) {
            // Restore old behavior if needed
            $table->unique(['key'], 'app_contents_key_unique');
        });
    }
};