<?php
// File: /home/okgroups/public_html/sm.okgroups.com/database/migrations/2026_02_18_000001_create_device_telemetries_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('device_telemetries', function (Blueprint $table) {
            $table->id();

            // stable device id (SSAID on Android)
            $table->string('device_id', 128)->unique();

            // "store once" fields
            $table->string('device_model', 120)->nullable();
            $table->string('os', 16)->nullable();
            $table->string('os_version', 32)->nullable();
            $table->string('app_version', 32)->nullable();

            // locales (can change)
            $table->string('device_locale', 16)->nullable();
            $table->string('app_locale', 16)->nullable();

            // ✅ NEW: IP و Country Code
            $table->string('user_ip', 45)->nullable();
            $table->string('country_code', 2)->nullable();

            // counters & timestamps
            $table->unsignedBigInteger('open_count')->default(0);
            $table->timestamp('first_seen_at')->nullable();
            $table->timestamp('last_seen_at')->nullable();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('device_telemetries');
    }
};