<?php
// File: database/migrations/YYYY_MM_DD_HHMMSS_create_fraud_alerts_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('fraud_alerts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('purchase_id')->nullable()->constrained('purchases')->nullOnDelete();
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->string('device_id')->nullable();
            $table->enum('alert_type', [
                'FRAUD_DEVICE_NOT_FOUND',
                'FRAUD_MISMATCH',
                'DUPLICATE_RECEIPT',
                'SUSPICIOUS_PATTERN'
            ])->default('FRAUD_DEVICE_NOT_FOUND');
            $table->text('description')->nullable();
            $table->string('ip_address')->nullable();
            $table->text('user_agent')->nullable();
            $table->enum('status', ['pending', 'reviewed', 'resolved'])->default('pending');
            $table->timestamps();
            
            $table->index(['alert_type', 'status']);
            $table->index('user_id');
            $table->index('device_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('fraud_alerts');
    }
};