<?php
// File: sm.okgroups.com/project_root/database/seeders/AppContentsSeeder.php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\AppContent;

class AppContentsSeeder extends Seeder
{
    public function run(): void
    {
        $items = [
            ['key' => 'about',  'title' => 'About Us'],
            ['key' => 'terms',  'title' => 'Terms of Use'],
            ['key' => 'privacy','title' => 'Privacy Policy'],

            // مواردی که گفتی از همینجا مدیریت بشن:
            ['key' => 'version_popup', 'title' => 'Version Popup'],
            ['key' => 'voucher_popup', 'title' => 'Voucher Popup Text'],
        ];

        foreach ($items as $it) {
            AppContent::firstOrCreate(
                ['key' => $it['key']],
                [
                    'title' => $it['title'],
                    'format' => 'html',
                    'body' => '',
                    'is_active' => true,
                    'is_verified' => true,
                ]
            );
        }
    }
}
