{{-- File: /home/okgroups/public_html/sm.okgroups.com/resources/views/settings/app_contents.blade.php --}}

@extends('layouts.app')

@section('page-title', __('App Contents'))
@section('page-heading', __('App Contents'))

@section('breadcrumbs')
    <li class="breadcrumb-item text-muted">@lang('Settings')</li>
    <li class="breadcrumb-item active">@lang('App Contents')</li>
@stop

@section('content')

@include('partials.messages')

<div class="card">
    <div class="card-body">

        <p class="text-muted mb-3">
            @lang('Select a key and edit the text in 19 languages.')
        </p>

        {{-- Key selector (GET) --}}
        <form method="GET" action="{{ route('settings.app_contents.index') }}" class="mb-3">
            <div class="form-row align-items-end">
                <div class="col-md-6">
                    <label class="mb-1">@lang('Content Key')</label>
                    <select name="key" class="form-control" onchange="this.form.submit()">
                        @foreach($keys as $k)
                            <option value="{{ $k }}" {{ $selectedKey === $k ? 'selected' : '' }}>
                                {{ $k }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6 text-muted small">
                    @if($selectedKey === 'voucher_popup')
                        <div class="mt-2">
                            <strong class="text-danger">voucher_popup:</strong>
                            keep <code>{code}</code> in the body for all languages.
                        </div>
                    @endif
                </div>
            </div>
        </form>

        {{-- Save form (POST) --}}
        <form method="POST" action="{{ route('settings.app_contents.update') }}">
            @csrf
            <input type="hidden" name="key" value="{{ $selectedKey }}">

            {{-- Meta (optional / readonly display) --}}
            <div class="row mb-3">
                <div class="col-md-4">
                    <label class="mb-1">Format</label>
                    <input type="text" class="form-control" value="{{ $meta['format'] ?? 'html' }}" disabled>
                    <input type="hidden" name="meta[format]" value="{{ $meta['format'] ?? 'html' }}">
                </div>
                <div class="col-md-4">
                    <label class="mb-1">Active</label>
                    <input type="text" class="form-control" value="{{ (int)($meta['is_active'] ?? 1) }}" disabled>
                    <input type="hidden" name="meta[is_active]" value="{{ (int)($meta['is_active'] ?? 1) }}">
                </div>
                <div class="col-md-4">
                    <label class="mb-1">Verified</label>
                    <input type="text" class="form-control" value="{{ (int)($meta['is_verified'] ?? 1) }}" disabled>
                    <input type="hidden" name="meta[is_verified]" value="{{ (int)($meta['is_verified'] ?? 1) }}">
                </div>
            </div>

            {{-- Language tabs --}}
            <ul class="nav nav-tabs mb-3" role="tablist">
                @foreach($langs as $i => $l)
                    <li class="nav-item">
                        <a class="nav-link {{ $i === 0 ? 'active' : '' }}"
                           id="tab-{{ $l['code'] }}"
                           data-toggle="tab"
                           href="#pane-{{ $l['code'] }}"
                           role="tab">
                            {{ $l['name'] }} <small class="text-muted">({{ $l['code'] }})</small>
                        </a>
                    </li>
                @endforeach
            </ul>

            <div class="tab-content">
                @foreach($langs as $i => $l)
                    @php $lc = $l['code']; @endphp
                    <div class="tab-pane fade {{ $i === 0 ? 'show active' : '' }}"
                         id="pane-{{ $lc }}"
                         role="tabpanel">

                        <div class="form-group">
                            <label>@lang('Title') ({{ $lc }})</label>
                            <input type="text"
                                   class="form-control"
                                   name="items[{{ $lc }}][title]"
                                   value="{{ old("items.$lc.title", $items[$lc]['title'] ?? '') }}">
                            @error("items.$lc.title")
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label>@lang('Body') ({{ $lc }})</label>
                            <textarea class="form-control"
                                      name="items[{{ $lc }}][body]"
                                      rows="14">{{ old("items.$lc.body", $items[$lc]['body'] ?? '') }}</textarea>

                            @if($selectedKey === 'voucher_popup')
                                <small class="text-muted">Must include <code>{code}</code></small>
                            @endif

                            @error("items.$lc.body")
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>

                    </div>
                @endforeach
            </div>

            <div class="mt-3">
                <button class="btn btn-primary" type="submit">
                    <i class="fa fa-save"></i> @lang('Save')
                </button>
            </div>

        </form>

    </div>
</div>

@stop