{{-- File: /home/okgroups/public_html/sm.okgroups.com/resources/views/settings/general.blade.php --}}

@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header">{{ __('General Settings') }}</div>

                <div class="card-body">
                    <form method="POST" action="{{ route('settings.general.update') }}">
                        @csrf

                        {{-- ========================================
                             SECTION 1: اطلاعات عمومی اپلیکیشن
                        ========================================= --}}
                        <h5 class="mb-3 text-primary">
                            <i class="fas fa-mobile-alt"></i> اطلاعات عمومی اپلیکیشن
                        </h5>

                        {{-- App Name --}}
                        <div class="form-group mb-3">
                            <label for="app_name">{{ __('App Name') }}</label>
                            <input
                                id="app_name"
                                type="text"
                                class="form-control @error('app_name') is-invalid @enderror"
                                name="app_name"
                                value="{{ old('app_name', $settings['app_name'] ?? '') }}"
                                autocomplete="off"
                            >
                            @error('app_name')
                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>

                        {{-- Android Share URL --}}
                        <div class="form-group mb-3">
                            <label for="android_share_url">{{ __('Android Share URL') }}</label>
                            <input
                                id="android_share_url"
                                type="text"
                                class="form-control @error('android_share_url') is-invalid @enderror"
                                name="android_share_url"
                                value="{{ old('android_share_url', $settings['android_share_url'] ?? '') }}"
                                autocomplete="off"
                                placeholder="https://play.google.com/store/apps/details?id=..."
                            >
                            @error('android_share_url')
                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>

                        {{-- iOS Share URL --}}
                        <div class="form-group mb-3">
                            <label for="ios_share_url">{{ __('iOS Share URL') }}</label>
                            <input
                                id="ios_share_url"
                                type="text"
                                class="form-control @error('ios_share_url') is-invalid @enderror"
                                name="ios_share_url"
                                value="{{ old('ios_share_url', $settings['ios_share_url'] ?? '') }}"
                                autocomplete="off"
                                placeholder="https://apps.apple.com/app/..."
                            >
                            @error('ios_share_url')
                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>

                        <hr class="my-4">

                        {{-- ========================================
                             SECTION 2: به‌روزرسانی اجباری (Force Update)
                        ========================================= --}}
                        <h5 class="mb-3 text-primary">
                            <i class="fas fa-sync-alt"></i> به‌روزرسانی اجباری (Force Update)
                        </h5>

                        {{-- ✅ Android App Version --}}
                        <div class="form-group mb-3">
                            <label for="android_app_version">{{ __('Android App Version') }}</label>
                            <input
                                id="android_app_version"
                                type="text"
                                class="form-control @error('android_app_version') is-invalid @enderror"
                                name="android_app_version"
                                placeholder="مثال: 1.0.12"
                                value="{{ old('android_app_version', $settings['android_app_version'] ?? '') }}"
                                autocomplete="off"
                            >
                            @error('android_app_version')
                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                            @enderror
                            <small class="text-muted">
                                نسخه‌ای که اپ اندروید باید حداقل برابر یا بالاتر از آن باشد تا اجرا شود.
                            </small>
                        </div>

                        {{-- ✅ iOS App Version --}}
                        <div class="form-group mb-3">
                            <label for="ios_app_version">{{ __('iOS App Version') }}</label>
                            <input
                                id="ios_app_version"
                                type="text"
                                class="form-control @error('ios_app_version') is-invalid @enderror"
                                name="ios_app_version"
                                placeholder="مثال: 1.0.12"
                                value="{{ old('ios_app_version', $settings['ios_app_version'] ?? '') }}"
                                autocomplete="off"
                            >
                            @error('ios_app_version')
                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                            @enderror
                            <small class="text-muted">
                                نسخه‌ای که اپ iOS باید حداقل برابر یا بالاتر از آن باشد تا اجرا شود.
                            </small>
                        </div>

                        {{-- ✅ Force Update Text (Multilingual via App Contents) --}}
                        <div class="form-group mb-3">
                            <label>{{ __('Force Update Text') }}</label>

                            <div class="alert alert-info mb-2">
                                <i class="fas fa-info-circle"></i>
                                این متن چندزبانه است و از بخش App Contents مدیریت می‌شود.
                            </div>

                            <a
                                class="btn btn-outline-primary"
                                href="{{ url('/settings/app-contents?key=force_update_text') }}"
                            >
                                <i class="fas fa-edit"></i> ویرایش متن چندزبانه
                            </a>

                            <div class="mt-2 text-muted">
                                کلید: <code>force_update_text</code> در جدول <code>app_contents</code>
                            </div>

                            <small class="text-muted d-block mt-2">
                                اگر نسخه اپ پایین‌تر از نسخه تنظیم‌شده باشد، متن چندزبانه‌ی این کلید داخل پاپاپ نمایش داده می‌شود.
                            </small>
                        </div>

                        <hr class="my-4">

                        {{-- ========================================
                             SECTION 3: پاداش ثبت‌نام (Signup Bonus)
                        ========================================= --}}
                        <h5 class="mb-3 text-primary">
                            <i class="fas fa-gift"></i> پاداش ثبت‌نام (Signup Bonus)
                        </h5>

                        {{-- ✅ Signup Bonus Minutes --}}
                        <div class="form-group mb-3">
                            <label for="signup_bonus_minutes">
                                <i class="fas fa-clock"></i> دقیقه پاداش ثبت‌نام
                            </label>
                            <input
                                id="signup_bonus_minutes"
                                type="number"
                                class="form-control @error('signup_bonus_minutes') is-invalid @enderror"
                                name="signup_bonus_minutes"
                                value="{{ old('signup_bonus_minutes', $settings['signup_bonus_minutes'] ?? '3') }}"
                                min="0"
                                max="1440"
                                step="1"
                                autocomplete="off"
                            >
                            @error('signup_bonus_minutes')
                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                            @enderror
                            <small class="text-muted d-block mt-1">
                                <i class="fas fa-info-circle"></i>
                                کاربران جدید هنگام ثبت‌نام، این تعداد دقیقه به‌صورت خودکار به حسابشان اضافه می‌شود.
                            </small>
                            <small class="text-muted d-block">
                                (حداقل: 0، حداکثر: 1440 دقیقه = 24 ساعت)
                            </small>
                        </div>

                        <hr class="my-4">

                        {{-- ========================================
                             دکمه ذخیره
                        ========================================= --}}
                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="fas fa-save"></i> {{ __('Save') }}
                            </button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection