<?php
// File: /home/okgroups/public_html/sm.okgroups.com/resources/views/settings/vouchers/create.blade.php
?>

@extends('layouts.app')

@section('page-title', 'Create Voucher')
@section('page-heading', 'Create Voucher')

@section('content')
<div class="row">
    <div class="col-md-8">

        <div class="panel panel-default">
            <div class="panel-heading"><strong>Create Voucher</strong></div>
            <div class="panel-body">

                @if($errors->any())
                    <div class="alert alert-danger">
                        <ul style="margin:0;padding-left:18px;">
                            @foreach($errors->all() as $e)
                                <li>{{ $e }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form method="POST" action="{{ route('settings.vouchers.store') }}">
                    @csrf

                    <div class="form-group">
                        <label>Code (optional)</label>
                        <input type="text" class="form-control" name="code" value="{{ old('code') }}" placeholder="Leave empty to auto-generate">
                    </div>

                    <div class="form-group">
                        <label>Seconds</label>
                        <input type="number" class="form-control" name="seconds" value="{{ old('seconds', 3600) }}" min="1" required>
                    </div>

                    <div class="form-group">
                        <label>Max Uses</label>
                        <input type="number" class="form-control" name="max_uses" value="{{ old('max_uses', 1) }}" min="1">
                    </div>

                    <div class="form-group">
                        <label>Price (optional)</label>
                        <input type="text" class="form-control" name="price" value="{{ old('price') }}" placeholder="e.g. 1.000">
                    </div>

                    <div class="form-group">
                        <label>Title (optional)</label>
                        <input type="text" class="form-control" name="title" value="{{ old('title') }}" placeholder="e.g. 1 hour voucher">
                    </div>

                    <div class="form-group">
                        <label>Expires At (optional)</label>
                        <input type="datetime-local" class="form-control" name="expires_at" value="{{ old('expires_at') }}">
                    </div>

                    <div class="checkbox">
                        <label>
                            <input type="checkbox" name="is_active" value="1" {{ old('is_active', '1') ? 'checked' : '' }}>
                            Active
                        </label>
                    </div>

                    <div style="margin-top:15px;">
                        <button class="btn btn-primary">Create</button>
                        <a href="{{ route('settings.vouchers.index') }}" class="btn btn-default">Back</a>
                    </div>

                </form>

            </div>
        </div>

    </div>
</div>
@endsection
