<?php
// File: /home/okgroups/public_html/sm.okgroups.com/resources/views/settings/vouchers/index.blade.php
?>

@extends('layouts.app')

@section('page-title', 'Vouchers')
@section('page-heading', 'Vouchers')

@section('content')
<div class="row">
    <div class="col-md-12">

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <div class="panel panel-default">
            <div class="panel-heading">
                <div class="d-flex" style="display:flex;justify-content:space-between;align-items:center;">
                    <strong>Voucher List</strong>
                    <a href="{{ route('settings.vouchers.create') }}" class="btn btn-primary btn-sm">Create Voucher</a>
                </div>
            </div>

            <div class="panel-body">

                <form method="GET" action="{{ route('settings.vouchers.index') }}" class="form-inline" style="margin-bottom:15px;">
                    <div class="form-group" style="margin-right:10px;">
                        <input type="text" name="search" class="form-control input-sm" placeholder="Search code..."
                               value="{{ request('search') }}">
                    </div>

                    <div class="form-group" style="margin-right:10px;">
                        <select name="status" class="form-control input-sm">
                            <option value="">All</option>
                            <option value="active"  @selected(request('status')==='active')>Active</option>
                            <option value="inactive" @selected(request('status')==='inactive')>Inactive</option>
                            <option value="used" @selected(request('status')==='used')>Used</option>
                            <option value="expired" @selected(request('status')==='expired')>Expired</option>
                        </select>
                    </div>

                    <button class="btn btn-default btn-sm" type="submit">Filter</button>
                </form>

                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                        <tr>
                            <th>Code</th>
                            <th>Seconds</th>
                            <th>Uses</th>
                            <th>Active</th>
                            <th>Expires</th>
                            <th>Created</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($vouchers as $v)
                            <tr>
                                <td>
                                    <a href="{{ route('settings.vouchers.show', $v->id) }}"><strong>{{ $v->code }}</strong></a>
                                </td>
                                <td>{{ number_format($v->seconds) }}</td>
                                <td>{{ $v->uses_count }} / {{ $v->max_uses }}</td>
                                <td>{!! $v->is_active ? '<span class="label label-success">Yes</span>' : '<span class="label label-default">No</span>' !!}</td>
                                <td>{{ $v->expires_at ? $v->expires_at->format('Y-m-d H:i') : '-' }}</td>
                                <td>{{ $v->created_at ? $v->created_at->format('Y-m-d H:i') : '-' }}</td>
                            </tr>
                        @empty
                            <tr><td colspan="6">No vouchers found.</td></tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>

                {{ $vouchers->links() }}

            </div>
        </div>
    </div>
</div>
@endsection
