<?php
// File: /home/okgroups/public_html/sm.okgroups.com/resources/views/settings/vouchers/show.blade.php
?>

@extends('layouts.app')

@section('page-title', 'Voucher Details')
@section('page-heading', 'Voucher Details')

@section('content')
<div class="row">
    <div class="col-md-12">

        <div class="panel panel-default">
            <div class="panel-heading"><strong>Voucher: {{ $voucher->code }}</strong></div>
            <div class="panel-body">

                <div class="row">
                    <div class="col-md-4">
                        <p><strong>Seconds:</strong> {{ number_format($voucher->seconds) }}</p>
                        <p><strong>Uses:</strong> {{ $voucher->uses_count }} / {{ $voucher->max_uses }}</p>
                        <p><strong>Active:</strong> {!! $voucher->is_active ? '<span class="label label-success">Yes</span>' : '<span class="label label-default">No</span>' !!}</p>
                    </div>
                    <div class="col-md-4">
                        <p><strong>Price:</strong> {{ $voucher->price !== null ? $voucher->price : '-' }}</p>
                        <p><strong>Title:</strong> {{ $voucher->title ?: '-' }}</p>
                        <p><strong>Expires:</strong> {{ $voucher->expires_at ? $voucher->expires_at->format('Y-m-d H:i') : '-' }}</p>
                    </div>
                    <div class="col-md-4">
                        <p><strong>Created:</strong> {{ $voucher->created_at ? $voucher->created_at->format('Y-m-d H:i') : '-' }}</p>
                        <a href="{{ route('settings.vouchers.index') }}" class="btn btn-default btn-sm">Back</a>
                    </div>
                </div>

                <hr>

                <h4>Redemption Log</h4>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                        <tr>
                            <th>Status</th>
                            <th>Reason</th>
                            <th>User</th>
                            <th>Device</th>
                            <th>IP</th>
                            <th>Time</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($redemptions as $r)
                            <tr>
                                <td>
                                    {!! $r->status === 'success'
                                        ? '<span class="label label-success">success</span>'
                                        : '<span class="label label-danger">failed</span>' !!}
                                </td>
                                <td>{{ $r->fail_reason ?: '-' }}</td>
                                <td>{{ $r->user_id ?: '-' }}</td>
                                <td style="max-width:260px;word-break:break-all;">{{ $r->device_id ?: '-' }}</td>
                                <td>{{ $r->ip ?: '-' }}</td>
                                <td>{{ $r->redeemed_at ? $r->redeemed_at->format('Y-m-d H:i') : '-' }}</td>
                            </tr>
                        @empty
                            <tr><td colspan="6">No redemptions yet.</td></tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>

                {{ $redemptions->links() }}

            </div>
        </div>

    </div>
</div>
@endsection
