@extends('layouts.app')

@section('page-title', __('Users'))
@section('page-heading', __('Users'))

@section('breadcrumbs')
    <li class="breadcrumb-item active">
        @lang('Users')
    </li>
@stop

@section('content')

@include('partials.messages')

<div class="card">
    <div class="card-body">

        <form action="" method="GET" id="users-form" class="pb-2 mb-3 border-bottom-light">
            <div class="row my-3 flex-md-row flex-column-reverse">
                <div class="col-md-3 mt-md-0 mt-2">
                    <div class="input-group custom-search-form">
                        <input type="text"
                               class="form-control input-solid"
                               name="search"
                               value="{{ Request::get('search') }}"
                               placeholder="@lang('Search by User Code...')">

                            <span class="input-group-append">
                                @if (Request::has('search') && Request::get('search') != '')
                                    <a href="{{ route('users.index') }}"
                                           class="btn btn-light d-flex align-items-center text-muted"
                                           role="button">
                                        <i class="fas fa-times"></i>
                                    </a>
                                @endif
                                <button class="btn btn-light" type="submit" id="search-users-btn">
                                    <i class="fas fa-search text-muted"></i>
                                </button>
                            </span>
                    </div>
                </div>

                {{-- ✅ فیلتر Status --}}
                <div class="col-md-2 mt-2 mt-md-0">
                    <select name="status" id="status" class="form-control input-solid">
                        @foreach($statuses as $key => $value)
                            <option value="{{ $key }}" {{ Request::get('status') == $key ? 'selected' : '' }}>
                                {{ $value }}
                            </option>
                        @endforeach
                    </select>
                </div>

                {{-- ✅ فیلتر OS --}}
                <div class="col-md-2 mt-2 mt-md-0">
                    <select name="os_filter" id="os_filter" class="form-control input-solid">
                        <option value="">@lang('All OS')</option>
                        <option value="android" {{ Request::get('os_filter') == 'android' ? 'selected' : '' }}>
                            Android
                        </option>
                        <option value="ios" {{ Request::get('os_filter') == 'ios' ? 'selected' : '' }}>
                            iOS
                        </option>
                        <option value="no_device" {{ Request::get('os_filter') == 'no_device' ? 'selected' : '' }}>
                            @lang('No Device')
                        </option>
                    </select>
                </div>

                {{-- ✅ فیلتر Credit --}}
                <div class="col-md-2 mt-2 mt-md-0">
                    <select name="credit_filter" id="credit_filter" class="form-control input-solid">
                        <option value="">@lang('All Credit')</option>
                        <option value="zero" {{ Request::get('credit_filter') == 'zero' ? 'selected' : '' }}>
                            @lang('Zero Credit')
                        </option>
                        <option value="low" {{ Request::get('credit_filter') == 'low' ? 'selected' : '' }}>
                            @lang('Low (≤5 min)')
                        </option>
                        <option value="high" {{ Request::get('credit_filter') == 'high' ? 'selected' : '' }}>
                            @lang('High (>5 min)')
                        </option>
                    </select>
                </div>

                <div class="col-md-3">
                    <a href="{{ route('users.create') }}" class="btn btn-primary btn-rounded float-right">
                        <i class="fas fa-plus mr-2"></i>
                        @lang('Add User')
                    </a>
                </div>
            </div>

            @if(Request::hasAny(['search', 'status', 'os_filter', 'credit_filter']))
                <div class="row">
                    <div class="col-md-12">
                        <a href="{{ route('users.index') }}" class="btn btn-sm btn-outline-secondary">
                            <i class="fas fa-redo mr-1"></i> @lang('Reset All Filters')
                        </a>
                    </div>
                </div>
            @endif
        </form>

        <div class="table-responsive" id="users-table-wrapper" style="min-height: 200px;">
            <table class="table table-borderless table-striped">
                <thead style="background-color: #f8f9fa; border-bottom: 2px solid #dee2e6;">
                <tr>
                    <th></th>
                    <th class="min-width-120" style="font-weight: 600; color: #495057;">User Code</th>

                    {{-- ✅ Credit با فلش سورت --}}
                    <th class="min-width-120" style="font-weight: 600; color: #495057;">
                        <a href="{{ route('users.index', array_merge(request()->all(), ['sort' => 'credit', 'order' => (request('sort') == 'credit' && request('order') == 'asc') ? 'desc' : 'asc'])) }}"
                           class="text-decoration-none d-flex align-items-center"
                           style="color: #495057; cursor: pointer;">
                            Credit
                            @if(request('sort') == 'credit')
                                <i class="fas fa-sort-{{ request('order') == 'asc' ? 'up' : 'down' }} ml-2" style="color: #007bff;"></i>
                            @else
                                <i class="fas fa-sort ml-2" style="opacity: 0.2;"></i>
                            @endif
                        </a>
                    </th>

                    <th class="min-width-120" style="font-weight: 600; color: #495057;">Device</th>
                    <th class="min-width-100" style="font-weight: 600; color: #495057;">OS</th>
                    <th class="min-width-80" style="font-weight: 600; color: #495057;">App</th>
                    <th class="min-width-120" style="font-weight: 600; color: #495057;">Last Seen</th>
                    
                    {{-- ✅ 3 ستون جدا --}}
                    <th class="min-width-60 text-center" style="font-weight: 600; color: #495057;">Opens</th>
                    <th class="min-width-60 text-center" style="font-weight: 600; color: #495057;">App Lang</th>
                    <th class="min-width-60 text-center" style="font-weight: 600; color: #495057;">Device Lang</th>

                    {{-- ✅ IP و Country Code --}}
                    <th class="min-width-120" style="font-weight: 600; color: #495057;">IP Address</th>
                    <th class="min-width-80 text-center" style="font-weight: 600; color: #495057;">Country</th>

                    {{-- ✅ Registration Date با فلش سورت --}}
                    <th class="min-width-100" style="font-weight: 600; color: #495057;">
                        <a href="{{ route('users.index', array_merge(request()->all(), ['sort' => 'created_at', 'order' => (request('sort') == 'created_at' && request('order') == 'desc') ? 'asc' : 'desc'])) }}"
                           class="text-decoration-none d-flex align-items-center"
                           style="color: #495057; cursor: pointer;">
                            @lang('Reg. Date')
                            @if(request('sort') == 'created_at' || !request('sort'))
                                <i class="fas fa-sort-{{ request('order', 'desc') == 'desc' ? 'down' : 'up' }} ml-2" style="color: #007bff;"></i>
                            @else
                                <i class="fas fa-sort ml-2" style="opacity: 0.2;"></i>
                            @endif
                        </a>
                    </th>

                    <th class="min-width-80" style="font-weight: 600; color: #495057;">@lang('Status')</th>
                    <th class="text-center min-width-150" style="font-weight: 600; color: #495057;">Manual Credit</th>
                    <th class="text-center min-width-120" style="font-weight: 600; color: #495057;">@lang('Action')</th>
                </tr>
                </thead>
                <tbody>
                    @if (count($users))
                        @foreach ($users as $user)
                            @include('user.partials.row', [
                                'user' => $user,
                                'deviceTelemetry' => $user->deviceTelemetry
                            ])
                        @endforeach
                    @else
                        <tr>
                            <td colspan="17"><em>@lang('No records found.')</em></td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>

{!! $users->render() !!}

@stop

@section('scripts')
    <script>
        // ✅ Auto-submit on filter change
        $("#status, #os_filter, #credit_filter").change(function () {
            $("#users-form").submit();
        });
    </script>
@stop