{{-- File: /home/okgroups/public_html/sm.okgroups.com/resources/views/user/partials/row.blade.php --}}

@php
    // --- credit seconds (supports different column names safely) ---
    $sec =
        (int)($user->credit_seconds
        ?? $user->remaining_seconds
        ?? $user->credit
        ?? 0);

    if ($sec < 0) $sec = 0;

    $h = intdiv($sec, 3600);
    $m = intdiv($sec % 3600, 60);
    $s = $sec % 60;
    $creditHms = sprintf('%02d:%02d:%02d', $h, $m, $s);

    $publicCode = $user->public_code ?? $user->publicCode ?? null;

    // ✅ رنگ‌بندی بر اساس موجودی
    $creditMinutes = intdiv($sec, 60);
    if ($sec == 0) {
        $rowClass = 'table-danger'; // قرمز
        $creditBadge = 'badge-danger';
    } elseif ($creditMinutes <= 5) {
        $rowClass = 'table-warning'; // زرد
        $creditBadge = 'badge-warning';
    } else {
        $rowClass = '';
        $creditBadge = 'badge-primary';
    }

    // ✅ Device Telemetry Data
    $device = $user->deviceTelemetry;
    $deviceModel = $device->device_model ?? null;
    $os = $device->os ?? null;
    $osVersion = $device->os_version ?? null;
    $appVersion = $device->app_version ?? null;
    $lastSeen = $device->last_seen_at ?? null;
    $openCount = $device->open_count ?? null;
    $deviceLocale = $device->device_locale ?? null;
    $appLocale = $device->app_locale ?? null;
    
    // ✅ NEW: IP و Country Code از device_telemetry
    $userIp = $device->user_ip ?? null;
    $countryCode = $device->country_code ?? null;
@endphp

<tr class="{{ $rowClass }}">
    <td style="width: 40px;">
        <a href="{{ route('users.show', $user) }}">
            <img
                class="rounded-circle img-responsive"
                width="40"
                src="{{ $user->present()->avatar }}"
                alt="{{ $user->present()->name }}">
        </a>
    </td>

    {{-- ✅ User Code --}}
    <td class="align-middle">
        <span class="badge badge-light px-3 py-2" style="font-size: 13px; font-weight: 600; color: #495057;">
            {{ $publicCode ?: 'N/A' }}
        </span>
    </td>

    {{-- ✅ Credit با رنگ‌بندی --}}
    <td class="align-middle">
        <div class="d-flex align-items-center">
            <span class="badge {{ $creditBadge }} px-3 py-2" style="font-size: 13px; font-weight: 600;">
                {{ $creditHms }}
            </span>
        </div>
        <small class="text-muted d-block mt-1" style="font-size: 10px;">{{ number_format($sec) }} sec</small>
    </td>

    {{-- ✅ Device Model - استایل حرفه‌ای --}}
    <td class="align-middle">
        @if($deviceModel)
            <span class="text-dark" style="font-size: 12px; font-weight: 500;" title="{{ $deviceModel }}">
                {{ Str::limit($deviceModel, 18) }}
            </span>
        @else
            <span class="text-muted" style="font-size: 12px;">—</span>
        @endif
    </td>

    {{-- ✅ OS - استایل حرفه‌ای --}}
    <td class="align-middle">
        @if($os)
            <span class="text-dark" style="font-size: 12px; font-weight: 500;">
                {{ $os }}{{ $osVersion ? ' ' . $osVersion : '' }}
            </span>
        @else
            <span class="text-muted" style="font-size: 12px;">—</span>
        @endif
    </td>

    {{-- ✅ App Version - استایل حرفه‌ای --}}
    <td class="align-middle">
        @if($appVersion)
            <span class="text-dark" style="font-size: 12px; font-weight: 500;">
                v{{ $appVersion }}
            </span>
        @else
            <span class="text-muted" style="font-size: 12px;">—</span>
        @endif
    </td>

    {{-- ✅ Last Seen - استایل حرفه‌ای (با Timezone عمان +4) --}}
    <td class="align-middle">
        @if($lastSeen)
            <div>
                <div style="font-size: 12px; font-weight: 500; color: #212529;">
                    {{ $lastSeen->diffForHumans() }}
                </div>
                <small class="text-muted" style="font-size: 10px; display: block; margin-top: 2px;">
                    {{ $lastSeen->setTimezone('+04:00')->format('M d, H:i') }}
                </small>
            </div>
        @else
            <span class="text-muted" style="font-size: 12px;">—</span>
        @endif
    </td>

    {{-- ✅ Opens Count - فقط تعداد --}}
    <td class="align-middle text-center">
        @if($openCount !== null)
            <span class="font-weight-bold" style="font-size: 14px; color: #212529;">
                {{ number_format($openCount) }}
            </span>
        @else
            <span class="text-muted" style="font-size: 12px;">—</span>
        @endif
    </td>

    {{-- ✅ App Language - ستون جدا --}}
    <td class="align-middle text-center">
        @if($appLocale)
            <span class="badge badge-secondary" style="font-size: 11px; padding: 4px 8px;">
                {{ strtoupper($appLocale) }}
            </span>
        @else
            <span class="text-muted" style="font-size: 12px;">—</span>
        @endif
    </td>

    {{-- ✅ Device Language - ستون جدا --}}
    <td class="align-middle text-center">
        @if($deviceLocale)
            <span class="badge badge-info" style="font-size: 11px; padding: 4px 8px;">
                {{ strtoupper($deviceLocale) }}
            </span>
        @else
            <span class="text-muted" style="font-size: 12px;">—</span>
        @endif
    </td>

    {{-- ✅ NEW: IP Address --}}
    <td class="align-middle">
        @if($userIp)
            <span class="text-dark" style="font-size: 12px; font-weight: 500;" title="{{ $userIp }}">
                {{ $userIp }}
            </span>
        @else
            <span class="text-muted" style="font-size: 12px;">—</span>
        @endif
    </td>

    {{-- ✅ NEW: Country Code --}}
    <td class="align-middle text-center">
        @if($countryCode)
            <span class="badge badge-success" style="font-size: 12px; padding: 4px 8px; font-weight: 600;">
                {{ strtoupper($countryCode) }}
            </span>
        @else
            <span class="text-muted" style="font-size: 12px;">—</span>
        @endif
    </td>

    {{-- ✅ Registration Date با ساعت و دقیقه و Timezone عمان +4 --}}
    <td class="align-middle">
        @if($user->created_at)
            <div>
                <div style="font-size: 12px; font-weight: 500; color: #212529;">
                    {{ $user->created_at->setTimezone('+04:00')->format('M d, Y') }}
                </div>
                <small class="text-muted" style="font-size: 10px; display: block; margin-top: 2px;">
                    {{ $user->created_at->setTimezone('+04:00')->format('H:i') }}
                </small>
            </div>
        @else
            <span class="text-muted" style="font-size: 12px;">—</span>
        @endif
    </td>

    <td class="align-middle">
        <span class="badge badge-lg badge-{{ $user->present()->labelClass }}">
            {{ trans("app.status.{$user->status->value}") }}
        </span>
    </td>

    {{-- ✅ Admin Credit Controls - Compact --}}
    <td class="align-middle">
        <div class="d-flex align-items-center justify-content-center" style="gap: 5px;">
            {{-- Add minutes --}}
            <form method="POST" action="{{ route('users.credit.add', $user) }}" class="d-inline-flex align-items-center" style="gap: 3px;">
                @csrf
                @method('PUT')
                <input type="number"
                       name="minutes"
                       class="form-control form-control-sm text-center"
                       placeholder="+"
                       min="1"
                       step="1"
                       required
                       style="width: 50px; font-size: 12px; padding: 4px;">
                <button class="btn btn-success btn-sm" type="submit" style="padding: 4px 10px; font-size: 11px;">
                    <i class="fas fa-plus"></i>
                </button>
            </form>

            {{-- Set exact minutes --}}
            <form method="POST" action="{{ route('users.credit.set', $user) }}" class="d-inline-flex align-items-center" style="gap: 3px;">
                @csrf
                @method('PUT')
                <input type="number"
                       name="minutes"
                       class="form-control form-control-sm text-center"
                       placeholder="="
                       min="0"
                       step="1"
                       required
                       style="width: 50px; font-size: 12px; padding: 4px;">
                <button class="btn btn-warning btn-sm" type="submit" style="padding: 4px 10px; font-size: 11px;">
                    <i class="fas fa-check"></i>
                </button>
            </form>
        </div>
    </td>

    {{-- Action --}}
    <td class="text-center align-middle">
        <div class="dropdown show d-inline-block">
            <a class="btn btn-icon"
               href="#" role="button" id="dropdownMenuLink"
               data-toggle="dropdown"
               aria-haspopup="true" aria-expanded="false">
                <i class="fas fa-ellipsis-h"></i>
            </a>

            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuLink">
                @if (config('session.driver') == 'database')
                    <a href="{{ route('user.sessions', $user) }}" class="dropdown-item my-1 text-gray-500">
                        <i class="fas fa-list mr-2"></i>
                        @lang('User Sessions')
                    </a>
                @endif

                <a href="{{ route('users.show', $user) }}" class="dropdown-item my-1 text-gray-500">
                    <i class="fas fa-eye mr-2"></i>
                    @lang('View User')
                </a>

                @if ($user->isWaitingApproval())
                    <a href="{{ route('users.update.approve', $user->id) }}"
                        class="dropdown-item my-1 text-gray-500"
                        title="@lang('Approve')"
                        data-toggle="tooltip"
                        data-placement="top"
                        data-method="PUT"
                        data-confirm-title="@lang('Please Confirm')"
                        data-confirm-text="@lang('Are you sure that you want to approve this user?')"
                        data-confirm-delete="@lang('Approve')">
                        <i class="fas fa-check-square mr-2"></i>
                        @lang('Approve')
                    </a>
                @endif

                @canBeImpersonated($user)
                    <a href="{{ route('impersonate', $user) }}" class="dropdown-item my-1 text-gray-500 impersonate">
                        <i class="fas fa-user-secret mr-2"></i>
                        @lang('Impersonate')
                    </a>
                @endCanBeImpersonated
            </div>
        </div>

        <a href="{{ route('users.edit', $user) }}"
           class="btn btn-icon edit"
           title="@lang('Edit User')"
           data-toggle="tooltip" data-placement="top">
            <i class="fas fa-edit"></i>
        </a>

        <a href="{{ route('users.destroy', $user) }}"
           class="btn btn-icon"
           title="@lang('Delete User')"
           data-toggle="tooltip"
           data-placement="top"
           data-method="DELETE"
           data-confirm-title="@lang('Please Confirm')"
           data-confirm-text="@lang('Are you sure that you want to delete this user?')"
           data-confirm-delete="@lang('Yes, delete him!')">
            <i class="fas fa-trash"></i>
        </a>
    </td>
</tr>

<!-- ✅ خط جدا کننده -->
<tr style="height: 0;">
    <td colspan="20" style="padding: 0; border-bottom: 1px solid #d0d0d0;"></td>
</tr>