<div class="card">
    <div class="card-body">
        <h5 class="card-title mb-1"><?php echo app('translator')->get('Two-Factor Authentication'); ?></h5>

        <small class="text-muted d-block mb-4">
            <?php echo app('translator')->get('Enable/Disable Two-Factor Authentication for the application.'); ?>
        </small>

        <?php if(setting('2fa.enabled')): ?>
            <form method="POST" action="<?php echo e(route('settings.auth.2fa.disable')); ?>" id="auth-2fa-settings-form">
                <?php echo csrf_field(); ?>
                <button type="submit"
                        class="btn btn-danger"
                        data-toggle="loader"
                        data-loading-text="<?php echo app('translator')->get('Disabling...'); ?>">
                    <?php echo app('translator')->get('Disable'); ?>
                </button>
            </form>
        <?php else: ?>
            <form method="POST" action="<?php echo e(route('settings.auth.2fa.enable')); ?>" id="auth-2fa-settings-form">
                <?php echo csrf_field(); ?>
                <button type="submit"
                        class="btn btn-primary"
                        data-toggle="loader"
                        data-loading-text="<?php echo app('translator')->get('Enabling...'); ?>">
                    <?php echo app('translator')->get('Enable'); ?>
                </button>
            </form>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/okgroups/public_html/sm.okgroups.com/resources/views/settings/partials/two-factor.blade.php ENDPATH**/ ?>