<?php
    $showForcePasswordChange = $edit && !$profile && $user?->id !== auth()?->user()?->id && setting('password-change.enabled');
?>

<div class="form-group">
    <label for="email"><?php echo app('translator')->get('Email'); ?></label>
    <input type="email"
           class="form-control input-solid"
           id="email"
           name="email"
           placeholder="<?php echo app('translator')->get('Email'); ?>"
           value="<?php echo e($edit ? $user->email : ''); ?>">
</div>

<div class="form-group">
    <label for="username"><?php echo app('translator')->get('Username'); ?></label>
    <input type="text"
           class="form-control input-solid"
           id="username"
           placeholder="(<?php echo app('translator')->get('optional'); ?>)"
           name="username"
           value="<?php echo e($edit ? $user->username : ''); ?>">
</div>

<div class="form-group">
    <label for="password"><?php echo e($edit ? __("New Password") : __('Password')); ?></label>
    <input type="password"
           class="form-control input-solid"
           id="password"
           name="password"
           <?php if($edit): ?> placeholder="<?php echo app('translator')->get("Leave field blank if you don't want to change it"); ?>" <?php endif; ?>>
</div>

<div class="form-group">
    <label for="password_confirmation"><?php echo e($edit ? __("Confirm New Password") : __('Confirm Password')); ?></label>
    <input type="password"
           class="form-control input-solid"
           id="password_confirmation"
           name="password_confirmation"
           <?php if($edit): ?> placeholder="<?php echo app('translator')->get("Leave field blank if you don't want to change it"); ?>" <?php endif; ?>>
</div>

<?php if($showForcePasswordChange): ?>
    <div class="custom-control custom-checkbox">
        <input type="checkbox" class="custom-control-input"
               name="force_password_change"
               id="force_password_change"
            <?php if(($edit ? $user->force_password_change : setting('password-change.enabled'))): echo 'checked'; endif; ?> />
        <label class="custom-control-label font-weight-normal" for="force_password_change">
            <?php echo app('translator')->get('Force Password Change on next login'); ?>
        </label>
    </div>
<?php endif; ?>

<?php if($edit): ?>
    <button type="submit"
            class="btn btn-primary <?php echo e($showForcePasswordChange ? 'mt-4' : 'mt-2'); ?>"
            id="update-login-details-btn">
        <i class="fa fa-refresh"></i>
        <?php echo app('translator')->get('Update Details'); ?>
    </button>
<?php endif; ?>
<?php /**PATH /home/okgroups/public_html/sm.okgroups.com/resources/views/user/partials/auth.blade.php ENDPATH**/ ?>