<div class="card">
    <h6 class="card-header">
        <?php echo app('translator')->get('General'); ?>
    </h6>

    <div class="card-body">
        <form method="POST" action="<?php echo e(route('settings.auth.update')); ?>" id="auth-general-settings-form">
            <?php echo csrf_field(); ?>

        <div class="form-group mb-4">
            <div class="d-flex align-items-center">
                 <div class="switch">
                     <input type="hidden" value="0" name="remember_me">
                     <input type="checkbox" name="remember_me" id="switch-remember-me" class="switch"
                               value="1" <?php echo e(setting('remember_me') ? 'checked' : ''); ?>>
                     <label for="switch-remember-me"></label>
                 </div>
                <div class="ml-3 d-flex flex-column">
                    <label class="mb-0"><?php echo app('translator')->get('Allow "Remember Me"'); ?></label>
                    <small class="pt-0 text-muted">
                        <?php echo app('translator')->get("Should 'Remember Me' checkbox be displayed on login form?"); ?>
                    </small>
                </div>
            </div>
        </div>

        <div class="form-group my-4">
            <div class="d-flex align-items-center">
                <div class="switch">
                    <input type="hidden" value="0" name="forgot_password">
                    <input type="checkbox" name="forgot_password" id="switch-forgot-pass" class="switch"
                           value="1" <?php echo e(setting('forgot_password') ? 'checked' : ''); ?>>
                    <label for="switch-forgot-pass"></label>
                </div>
                <div class="ml-3 d-flex flex-column">
                    <label class="mb-0"><?php echo app('translator')->get('Forgot Password'); ?></label>
                    <small class="pt-0 text-muted">
                        <?php echo app('translator')->get('Enable/Disable forgot password feature.'); ?>
                    </small>
                </div>
            </div>
        </div>

        <div class="form-group my-4">
            <label for="login_reset_token_lifetime">
                <?php echo app('translator')->get('Reset Token Lifetime'); ?> <br>
                <small class="text-muted">
                    <?php echo app('translator')->get('Number of minutes that the reset token should be considered valid.'); ?>
                </small>
            </label>
            <input type="text" name="login_reset_token_lifetime"
                   class="form-control input-solid" value="<?php echo e(setting('login_reset_token_lifetime', 30)); ?>">
        </div>

        <div class="form-group my-4">
            <label for="login_reset_token_lifetime">
                <?php echo app('translator')->get('Max Number of Active Sessions'); ?> <br>
                <small class="text-muted">
                    <?php echo app('translator')->get('Maximum number of active sessions per user. Set to 0 to allow unlimited number of active sessions.'); ?>
                    <br>
                    <?php echo app('translator')->get('Only applies when using database session driver.'); ?>
                </small>
            </label>
            <input type="text" name="max_active_sessions"
                   class="form-control input-solid" value="<?php echo e(setting('max_active_sessions', 0)); ?>">
        </div>

        <button type="submit" class="btn btn-primary">
            <?php echo app('translator')->get('Update'); ?>
        </button>
        </form>
    </div>
</div>
<?php /**PATH /home/okgroups/public_html/sm.okgroups.com/resources/views/settings/partials/auth.blade.php ENDPATH**/ ?>