<div class="card">
    <h6 class="card-header">
        <?php echo app('translator')->get('Authentication Throttling'); ?>
    </h6>

    <div class="card-body">
        <form method="POST" action="<?php echo e(route('settings.auth.update')); ?>" id="auth-throttle-settings-form">
        <?php echo csrf_field(); ?>

        <div class="form-group mb-4">
            <div class="d-flex align-items-center">
                <div class="switch">
                    <input type="hidden" value="0" name="throttle_enabled">
                    <input type="checkbox"
                           class="switch"
                           id="switch-throttle"
                           name="throttle_enabled"
                           value="1"
                        <?php echo e(setting('throttle_enabled') ? 'checked' : ''); ?>>
                    <label for="switch-throttle"></label>
                </div>
                <div class="ml-3 d-flex flex-column">
                    <label class="mb-0"><?php echo app('translator')->get('Throttle Authentication'); ?></label>
                    <small class="text-muted">
                        <?php echo app('translator')->get('Should the system throttle authentication attempts?'); ?>
                    </small>
                </div>
            </div>
        </div>

        <div class="form-group my-4">
            <label for="throttle_attempts">
                <?php echo app('translator')->get('Maximum Number of Attempts'); ?> <br>
                <small class="text-muted">
                    <?php echo app('translator')->get('Maximum number of incorrect login attempts before lockout.'); ?>
                </small>
            </label>
            <input type="text" name="throttle_attempts" class="form-control input-solid"
                   value="<?php echo e(setting('throttle_attempts', 10)); ?>">
        </div>

        <div class="form-group my-4">
            <label for="throttle_lockout_time">
                <?php echo app('translator')->get('Lockout Time'); ?> <br>
                <small class="text-muted">
                    <?php echo app('translator')->get('Number of minutes to lock the user out for after specified maximum number of incorrect login attempts.'); ?>
                </small>
            </label>

            <input type="text" name="throttle_lockout_time" class="form-control input-solid"
                   value="<?php echo e(setting('throttle_lockout_time', 1)); ?>">
        </div>

        <button type="submit" class="btn btn-primary">
            <?php echo app('translator')->get('Update'); ?>
        </button>
        </form>
    </div>
</div>
<?php /**PATH /home/okgroups/public_html/sm.okgroups.com/resources/views/settings/partials/throttling.blade.php ENDPATH**/ ?>