

<?php
    // --- credit seconds (supports different column names safely) ---
    $sec =
        (int)($user->credit_seconds
        ?? $user->remaining_seconds
        ?? $user->credit
        ?? 0);

    if ($sec < 0) $sec = 0;

    $h = intdiv($sec, 3600);
    $m = intdiv($sec % 3600, 60);
    $s = $sec % 60;
    $creditHms = sprintf('%02d:%02d:%02d', $h, $m, $s);

    $publicCode = $user->public_code ?? $user->publicCode ?? null;

    // ✅ رنگ‌بندی بر اساس موجودی
    $creditMinutes = intdiv($sec, 60);
    if ($sec == 0) {
        $rowClass = 'table-danger'; // قرمز
        $creditBadge = 'badge-danger';
    } elseif ($creditMinutes <= 5) {
        $rowClass = 'table-warning'; // زرد
        $creditBadge = 'badge-warning';
    } else {
        $rowClass = '';
        $creditBadge = 'badge-primary';
    }

    // ✅ Device Telemetry Data
    $device = $user->deviceTelemetry;
    $deviceModel = $device->device_model ?? null;
    $os = $device->os ?? null;
    $osVersion = $device->os_version ?? null;
    $appVersion = $device->app_version ?? null;
    $lastSeen = $device->last_seen_at ?? null;
    $openCount = $device->open_count ?? null;
    $deviceLocale = $device->device_locale ?? null;
    $appLocale = $device->app_locale ?? null;
    
    // ✅ NEW: IP و Country Code از device_telemetry
    $userIp = $device->user_ip ?? null;
    $countryCode = $device->country_code ?? null;
?>

<tr class="<?php echo e($rowClass); ?>">
    <td style="width: 40px;">
        <a href="<?php echo e(route('users.show', $user)); ?>">
            <img
                class="rounded-circle img-responsive"
                width="40"
                src="<?php echo e($user->present()->avatar); ?>"
                alt="<?php echo e($user->present()->name); ?>">
        </a>
    </td>

    
    <td class="align-middle">
        <span class="badge badge-light px-3 py-2" style="font-size: 13px; font-weight: 600; color: #495057;">
            <?php echo e($publicCode ?: 'N/A'); ?>

        </span>
    </td>

    
    <td class="align-middle">
        <div class="d-flex align-items-center">
            <span class="badge <?php echo e($creditBadge); ?> px-3 py-2" style="font-size: 13px; font-weight: 600;">
                <?php echo e($creditHms); ?>

            </span>
        </div>
        <small class="text-muted d-block mt-1" style="font-size: 10px;"><?php echo e(number_format($sec)); ?> sec</small>
    </td>

    
    <td class="align-middle">
        <?php if($deviceModel): ?>
            <span class="text-dark" style="font-size: 12px; font-weight: 500;" title="<?php echo e($deviceModel); ?>">
                <?php echo e(Str::limit($deviceModel, 18)); ?>

            </span>
        <?php else: ?>
            <span class="text-muted" style="font-size: 12px;">—</span>
        <?php endif; ?>
    </td>

    
    <td class="align-middle">
        <?php if($os): ?>
            <span class="text-dark" style="font-size: 12px; font-weight: 500;">
                <?php echo e($os); ?><?php echo e($osVersion ? ' ' . $osVersion : ''); ?>

            </span>
        <?php else: ?>
            <span class="text-muted" style="font-size: 12px;">—</span>
        <?php endif; ?>
    </td>

    
    <td class="align-middle">
        <?php if($appVersion): ?>
            <span class="text-dark" style="font-size: 12px; font-weight: 500;">
                v<?php echo e($appVersion); ?>

            </span>
        <?php else: ?>
            <span class="text-muted" style="font-size: 12px;">—</span>
        <?php endif; ?>
    </td>

    
    <td class="align-middle">
        <?php if($lastSeen): ?>
            <div>
                <div style="font-size: 12px; font-weight: 500; color: #212529;">
                    <?php echo e($lastSeen->diffForHumans()); ?>

                </div>
                <small class="text-muted" style="font-size: 10px; display: block; margin-top: 2px;">
                    <?php echo e($lastSeen->setTimezone('+04:00')->format('M d, H:i')); ?>

                </small>
            </div>
        <?php else: ?>
            <span class="text-muted" style="font-size: 12px;">—</span>
        <?php endif; ?>
    </td>

    
    <td class="align-middle text-center">
        <?php if($openCount !== null): ?>
            <span class="font-weight-bold" style="font-size: 14px; color: #212529;">
                <?php echo e(number_format($openCount)); ?>

            </span>
        <?php else: ?>
            <span class="text-muted" style="font-size: 12px;">—</span>
        <?php endif; ?>
    </td>

    
    <td class="align-middle text-center">
        <?php if($appLocale): ?>
            <span class="badge badge-secondary" style="font-size: 11px; padding: 4px 8px;">
                <?php echo e(strtoupper($appLocale)); ?>

            </span>
        <?php else: ?>
            <span class="text-muted" style="font-size: 12px;">—</span>
        <?php endif; ?>
    </td>

    
    <td class="align-middle text-center">
        <?php if($deviceLocale): ?>
            <span class="badge badge-info" style="font-size: 11px; padding: 4px 8px;">
                <?php echo e(strtoupper($deviceLocale)); ?>

            </span>
        <?php else: ?>
            <span class="text-muted" style="font-size: 12px;">—</span>
        <?php endif; ?>
    </td>

    
    <td class="align-middle">
        <?php if($userIp): ?>
            <span class="text-dark" style="font-size: 12px; font-weight: 500;" title="<?php echo e($userIp); ?>">
                <?php echo e($userIp); ?>

            </span>
        <?php else: ?>
            <span class="text-muted" style="font-size: 12px;">—</span>
        <?php endif; ?>
    </td>

    
    <td class="align-middle text-center">
        <?php if($countryCode): ?>
            <span class="badge badge-success" style="font-size: 12px; padding: 4px 8px; font-weight: 600;">
                <?php echo e(strtoupper($countryCode)); ?>

            </span>
        <?php else: ?>
            <span class="text-muted" style="font-size: 12px;">—</span>
        <?php endif; ?>
    </td>

    
    <td class="align-middle">
        <?php if($user->created_at): ?>
            <div>
                <div style="font-size: 12px; font-weight: 500; color: #212529;">
                    <?php echo e($user->created_at->setTimezone('+04:00')->format('M d, Y')); ?>

                </div>
                <small class="text-muted" style="font-size: 10px; display: block; margin-top: 2px;">
                    <?php echo e($user->created_at->setTimezone('+04:00')->format('H:i')); ?>

                </small>
            </div>
        <?php else: ?>
            <span class="text-muted" style="font-size: 12px;">—</span>
        <?php endif; ?>
    </td>

    <td class="align-middle">
        <span class="badge badge-lg badge-<?php echo e($user->present()->labelClass); ?>">
            <?php echo e(trans("app.status.{$user->status->value}")); ?>

        </span>
    </td>

    
    <td class="align-middle">
        <div class="d-flex align-items-center justify-content-center" style="gap: 5px;">
            
            <form method="POST" action="<?php echo e(route('users.credit.add', $user)); ?>" class="d-inline-flex align-items-center" style="gap: 3px;">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input type="number"
                       name="minutes"
                       class="form-control form-control-sm text-center"
                       placeholder="+"
                       min="1"
                       step="1"
                       required
                       style="width: 50px; font-size: 12px; padding: 4px;">
                <button class="btn btn-success btn-sm" type="submit" style="padding: 4px 10px; font-size: 11px;">
                    <i class="fas fa-plus"></i>
                </button>
            </form>

            
            <form method="POST" action="<?php echo e(route('users.credit.set', $user)); ?>" class="d-inline-flex align-items-center" style="gap: 3px;">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input type="number"
                       name="minutes"
                       class="form-control form-control-sm text-center"
                       placeholder="="
                       min="0"
                       step="1"
                       required
                       style="width: 50px; font-size: 12px; padding: 4px;">
                <button class="btn btn-warning btn-sm" type="submit" style="padding: 4px 10px; font-size: 11px;">
                    <i class="fas fa-check"></i>
                </button>
            </form>
        </div>
    </td>

    
    <td class="text-center align-middle">
        <div class="dropdown show d-inline-block">
            <a class="btn btn-icon"
               href="#" role="button" id="dropdownMenuLink"
               data-toggle="dropdown"
               aria-haspopup="true" aria-expanded="false">
                <i class="fas fa-ellipsis-h"></i>
            </a>

            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuLink">
                <?php if(config('session.driver') == 'database'): ?>
                    <a href="<?php echo e(route('user.sessions', $user)); ?>" class="dropdown-item my-1 text-gray-500">
                        <i class="fas fa-list mr-2"></i>
                        <?php echo app('translator')->get('User Sessions'); ?>
                    </a>
                <?php endif; ?>

                <a href="<?php echo e(route('users.show', $user)); ?>" class="dropdown-item my-1 text-gray-500">
                    <i class="fas fa-eye mr-2"></i>
                    <?php echo app('translator')->get('View User'); ?>
                </a>

                <?php if($user->isWaitingApproval()): ?>
                    <a href="<?php echo e(route('users.update.approve', $user->id)); ?>"
                        class="dropdown-item my-1 text-gray-500"
                        title="<?php echo app('translator')->get('Approve'); ?>"
                        data-toggle="tooltip"
                        data-placement="top"
                        data-method="PUT"
                        data-confirm-title="<?php echo app('translator')->get('Please Confirm'); ?>"
                        data-confirm-text="<?php echo app('translator')->get('Are you sure that you want to approve this user?'); ?>"
                        data-confirm-delete="<?php echo app('translator')->get('Approve'); ?>">
                        <i class="fas fa-check-square mr-2"></i>
                        <?php echo app('translator')->get('Approve'); ?>
                    </a>
                <?php endif; ?>

                <?php if (can_be_impersonated($user, )) : ?>
                    <a href="<?php echo e(route('impersonate', $user)); ?>" class="dropdown-item my-1 text-gray-500 impersonate">
                        <i class="fas fa-user-secret mr-2"></i>
                        <?php echo app('translator')->get('Impersonate'); ?>
                    </a>
                <?php endif; ?>
            </div>
        </div>

        <a href="<?php echo e(route('users.edit', $user)); ?>"
           class="btn btn-icon edit"
           title="<?php echo app('translator')->get('Edit User'); ?>"
           data-toggle="tooltip" data-placement="top">
            <i class="fas fa-edit"></i>
        </a>

        <a href="<?php echo e(route('users.destroy', $user)); ?>"
           class="btn btn-icon"
           title="<?php echo app('translator')->get('Delete User'); ?>"
           data-toggle="tooltip"
           data-placement="top"
           data-method="DELETE"
           data-confirm-title="<?php echo app('translator')->get('Please Confirm'); ?>"
           data-confirm-text="<?php echo app('translator')->get('Are you sure that you want to delete this user?'); ?>"
           data-confirm-delete="<?php echo app('translator')->get('Yes, delete him!'); ?>">
            <i class="fas fa-trash"></i>
        </a>
    </td>
</tr>

<!-- ✅ خط جدا کننده -->
<tr style="height: 0;">
    <td colspan="20" style="padding: 0; border-bottom: 1px solid #d0d0d0;"></td>
</tr><?php /**PATH /home/okgroups/public_html/sm.okgroups.com/resources/views/user/partials/row.blade.php ENDPATH**/ ?>