

<?php $__env->startSection('page-title', __('Users')); ?>
<?php $__env->startSection('page-heading', __('Users')); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item active">
        <?php echo app('translator')->get('Users'); ?>
    </li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('partials.messages', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="card">
    <div class="card-body">

        <form action="" method="GET" id="users-form" class="pb-2 mb-3 border-bottom-light">
            <div class="row my-3 flex-md-row flex-column-reverse">
                <div class="col-md-3 mt-md-0 mt-2">
                    <div class="input-group custom-search-form">
                        <input type="text"
                               class="form-control input-solid"
                               name="search"
                               value="<?php echo e(Request::get('search')); ?>"
                               placeholder="<?php echo app('translator')->get('Search by User Code...'); ?>">

                            <span class="input-group-append">
                                <?php if(Request::has('search') && Request::get('search') != ''): ?>
                                    <a href="<?php echo e(route('users.index')); ?>"
                                           class="btn btn-light d-flex align-items-center text-muted"
                                           role="button">
                                        <i class="fas fa-times"></i>
                                    </a>
                                <?php endif; ?>
                                <button class="btn btn-light" type="submit" id="search-users-btn">
                                    <i class="fas fa-search text-muted"></i>
                                </button>
                            </span>
                    </div>
                </div>

                
                <div class="col-md-2 mt-2 mt-md-0">
                    <select name="status" id="status" class="form-control input-solid">
                        <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>" <?php echo e(Request::get('status') == $key ? 'selected' : ''); ?>>
                                <?php echo e($value); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                
                <div class="col-md-2 mt-2 mt-md-0">
                    <select name="os_filter" id="os_filter" class="form-control input-solid">
                        <option value=""><?php echo app('translator')->get('All OS'); ?></option>
                        <option value="android" <?php echo e(Request::get('os_filter') == 'android' ? 'selected' : ''); ?>>
                            Android
                        </option>
                        <option value="ios" <?php echo e(Request::get('os_filter') == 'ios' ? 'selected' : ''); ?>>
                            iOS
                        </option>
                        <option value="no_device" <?php echo e(Request::get('os_filter') == 'no_device' ? 'selected' : ''); ?>>
                            <?php echo app('translator')->get('No Device'); ?>
                        </option>
                    </select>
                </div>

                
                <div class="col-md-2 mt-2 mt-md-0">
                    <select name="credit_filter" id="credit_filter" class="form-control input-solid">
                        <option value=""><?php echo app('translator')->get('All Credit'); ?></option>
                        <option value="zero" <?php echo e(Request::get('credit_filter') == 'zero' ? 'selected' : ''); ?>>
                            <?php echo app('translator')->get('Zero Credit'); ?>
                        </option>
                        <option value="low" <?php echo e(Request::get('credit_filter') == 'low' ? 'selected' : ''); ?>>
                            <?php echo app('translator')->get('Low (≤5 min)'); ?>
                        </option>
                        <option value="high" <?php echo e(Request::get('credit_filter') == 'high' ? 'selected' : ''); ?>>
                            <?php echo app('translator')->get('High (>5 min)'); ?>
                        </option>
                    </select>
                </div>

                <div class="col-md-3">
                    <a href="<?php echo e(route('users.create')); ?>" class="btn btn-primary btn-rounded float-right">
                        <i class="fas fa-plus mr-2"></i>
                        <?php echo app('translator')->get('Add User'); ?>
                    </a>
                </div>
            </div>

            <?php if(Request::hasAny(['search', 'status', 'os_filter', 'credit_filter'])): ?>
                <div class="row">
                    <div class="col-md-12">
                        <a href="<?php echo e(route('users.index')); ?>" class="btn btn-sm btn-outline-secondary">
                            <i class="fas fa-redo mr-1"></i> <?php echo app('translator')->get('Reset All Filters'); ?>
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </form>

        <div class="table-responsive" id="users-table-wrapper" style="min-height: 200px;">
            <table class="table table-borderless table-striped">
                <thead style="background-color: #f8f9fa; border-bottom: 2px solid #dee2e6;">
                <tr>
                    <th></th>
                    <th class="min-width-120" style="font-weight: 600; color: #495057;">User Code</th>

                    
                    <th class="min-width-120" style="font-weight: 600; color: #495057;">
                        <a href="<?php echo e(route('users.index', array_merge(request()->all(), ['sort' => 'credit', 'order' => (request('sort') == 'credit' && request('order') == 'asc') ? 'desc' : 'asc']))); ?>"
                           class="text-decoration-none d-flex align-items-center"
                           style="color: #495057; cursor: pointer;">
                            Credit
                            <?php if(request('sort') == 'credit'): ?>
                                <i class="fas fa-sort-<?php echo e(request('order') == 'asc' ? 'up' : 'down'); ?> ml-2" style="color: #007bff;"></i>
                            <?php else: ?>
                                <i class="fas fa-sort ml-2" style="opacity: 0.2;"></i>
                            <?php endif; ?>
                        </a>
                    </th>

                    <th class="min-width-120" style="font-weight: 600; color: #495057;">Device</th>
                    <th class="min-width-100" style="font-weight: 600; color: #495057;">OS</th>
                    <th class="min-width-80" style="font-weight: 600; color: #495057;">App</th>
                    <th class="min-width-120" style="font-weight: 600; color: #495057;">Last Seen</th>
                    
                    
                    <th class="min-width-60 text-center" style="font-weight: 600; color: #495057;">Opens</th>
                    <th class="min-width-60 text-center" style="font-weight: 600; color: #495057;">App Lang</th>
                    <th class="min-width-60 text-center" style="font-weight: 600; color: #495057;">Device Lang</th>

                    
                    <th class="min-width-120" style="font-weight: 600; color: #495057;">IP Address</th>
                    <th class="min-width-80 text-center" style="font-weight: 600; color: #495057;">Country</th>

                    
                    <th class="min-width-100" style="font-weight: 600; color: #495057;">
                        <a href="<?php echo e(route('users.index', array_merge(request()->all(), ['sort' => 'created_at', 'order' => (request('sort') == 'created_at' && request('order') == 'desc') ? 'asc' : 'desc']))); ?>"
                           class="text-decoration-none d-flex align-items-center"
                           style="color: #495057; cursor: pointer;">
                            <?php echo app('translator')->get('Reg. Date'); ?>
                            <?php if(request('sort') == 'created_at' || !request('sort')): ?>
                                <i class="fas fa-sort-<?php echo e(request('order', 'desc') == 'desc' ? 'down' : 'up'); ?> ml-2" style="color: #007bff;"></i>
                            <?php else: ?>
                                <i class="fas fa-sort ml-2" style="opacity: 0.2;"></i>
                            <?php endif; ?>
                        </a>
                    </th>

                    <th class="min-width-80" style="font-weight: 600; color: #495057;"><?php echo app('translator')->get('Status'); ?></th>
                    <th class="text-center min-width-150" style="font-weight: 600; color: #495057;">Manual Credit</th>
                    <th class="text-center min-width-120" style="font-weight: 600; color: #495057;"><?php echo app('translator')->get('Action'); ?></th>
                </tr>
                </thead>
                <tbody>
                    <?php if(count($users)): ?>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo $__env->make('user.partials.row', [
                                'user' => $user,
                                'deviceTelemetry' => $user->deviceTelemetry
                            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="17"><em><?php echo app('translator')->get('No records found.'); ?></em></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php echo $users->render(); ?>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        // ✅ Auto-submit on filter change
        $("#status, #os_filter, #credit_filter").change(function () {
            $("#users-form").submit();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/okgroups/public_html/sm.okgroups.com/resources/views/user/list.blade.php ENDPATH**/ ?>