<?php $__env->startSection('page-title', __('Edit User')); ?>
<?php $__env->startSection('page-heading', $user->present()->nameOrEmail); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item">
        <a href="<?php echo e(route('users.index')); ?>"><?php echo app('translator')->get('Users'); ?></a>
    </li>
    <li class="breadcrumb-item">
        <a href="<?php echo e(route('users.show', $user->id)); ?>">
            <?php echo e($user->present()->nameOrEmail); ?>

        </a>
    </li>
    <li class="breadcrumb-item active">
        <?php echo app('translator')->get('Edit'); ?>
    </li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('partials.messages', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php
    $activeTab = session('tab') ?? 'details';
?>


<?php if($user->isWaitingApproval()): ?>
    <div class="alert alert-warning d-flex justify-content-between align-items-center">
        <?php echo app('translator')->get('The user is waiting on your approval to be able to access the website.'); ?>
        <form action="<?php echo e(route('users.update.approve', $user->id)); ?>"
              method="POST"
              id="avatar-form"
              enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <button type="submit" class="btn btn-primary" id="update-details-btn">
                <i class="fa fa-refresh"></i>
                <?php echo app('translator')->get('Approve'); ?>
            </button>
        </form>
    </div>
<?php endif; ?>

<div class="row">
    <div class="col-8">
        <div class="card">
            <div class="card-body">
                <ul class="nav nav-tabs" id="nav-tab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link <?php echo e($activeTab == 'details' ? 'active' : ''); ?>"
                           id="details-tab"
                           data-toggle="tab"
                           href="#details"
                           role="tab"
                           aria-controls="home"
                           aria-selected="true">
                            <?php echo app('translator')->get('User Details'); ?>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link"
                           id="authentication-tab"
                           data-toggle="tab"
                           href="#login-details"
                           role="tab"
                           aria-controls="home"
                           aria-selected="true">
                            <?php echo app('translator')->get('Login Details'); ?>
                        </a>
                    </li>
                    <?php if(setting('2fa.enabled')): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e($activeTab == '2fa' ? 'active' : ''); ?>"
                               id="authentication-tab"
                               data-toggle="tab"
                               href="#2fa"
                               role="tab"
                               aria-controls="home"
                               aria-selected="true">
                                <?php echo app('translator')->get('Two-Factor Authentication'); ?>
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>

                <div class="tab-content mt-4" id="nav-tabContent">
                    <div class="tab-pane <?php echo e($activeTab == 'details' ? 'show active' : ''); ?> fade px-2"
                         id="details"
                         role="tabpanel"
                         aria-labelledby="nav-home-tab">
                        <form action="<?php echo e(route('users.update.details', $user)); ?>" method="POST" id="details-form">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <?php echo $__env->make('user.partials.details', ['profile' => false], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        </form>
                    </div>

                    <div class="tab-pane fade px-2"
                         id="login-details"
                         role="tabpanel"
                         aria-labelledby="nav-profile-tab">
                        <form action="<?php echo e(route('users.update.login-details', $user)); ?>"
                              method="POST"
                              id="login-details-form">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <?php echo $__env->make('user.partials.auth', ['profile' => false], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        </form>
                    </div>

                    <?php if(setting('2fa.enabled')): ?>
                        <div class="tab-pane <?php echo e($activeTab == '2fa' ? 'show active' : ''); ?> fade px-2" id="2fa" role="tabpanel" aria-labelledby="nav-profile-tab">
                            <?php echo $__env->make('user.partials.two-factor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        </div>
                    <?php endif; ?>
                </div>

            </div>
        </div>
    </div>

    <div class="col-4">
        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('user.update.avatar', $user->id)); ?>"
                      method="POST"
                      id="avatar-form"
                      enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo $__env->make('user.partials.avatar', ['updateUrl' => route('user.update.avatar.external', $user->id)], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/as/btn.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/as/profile.js')); ?>"></script>
    <?php echo JsValidator::formRequest('App\Http\Requests\User\UpdateDetailsRequest', '#details-form'); ?>

    <?php echo JsValidator::formRequest('App\Http\Requests\User\UpdateLoginDetailsRequest', '#login-details-form'); ?>


    <?php if(setting('2fa.enabled')): ?>
        <?php echo JsValidator::formRequest('App\Http\Requests\TwoFactor\EnableTwoFactorRequest', '#two-factor-form'); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/okgroups/public_html/sm.okgroups.com/resources/views/user/edit.blade.php ENDPATH**/ ?>