<?php
// File: /home/okgroups/public_html/sm.okgroups.com/resources/views/settings/vouchers/show.blade.php
?>



<?php $__env->startSection('page-title', 'Voucher Details'); ?>
<?php $__env->startSection('page-heading', 'Voucher Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12">

        <div class="panel panel-default">
            <div class="panel-heading"><strong>Voucher: <?php echo e($voucher->code); ?></strong></div>
            <div class="panel-body">

                <div class="row">
                    <div class="col-md-4">
                        <p><strong>Seconds:</strong> <?php echo e(number_format($voucher->seconds)); ?></p>
                        <p><strong>Uses:</strong> <?php echo e($voucher->uses_count); ?> / <?php echo e($voucher->max_uses); ?></p>
                        <p><strong>Active:</strong> <?php echo $voucher->is_active ? '<span class="label label-success">Yes</span>' : '<span class="label label-default">No</span>'; ?></p>
                    </div>
                    <div class="col-md-4">
                        <p><strong>Price:</strong> <?php echo e($voucher->price !== null ? $voucher->price : '-'); ?></p>
                        <p><strong>Title:</strong> <?php echo e($voucher->title ?: '-'); ?></p>
                        <p><strong>Expires:</strong> <?php echo e($voucher->expires_at ? $voucher->expires_at->format('Y-m-d H:i') : '-'); ?></p>
                    </div>
                    <div class="col-md-4">
                        <p><strong>Created:</strong> <?php echo e($voucher->created_at ? $voucher->created_at->format('Y-m-d H:i') : '-'); ?></p>
                        <a href="<?php echo e(route('settings.vouchers.index')); ?>" class="btn btn-default btn-sm">Back</a>
                    </div>
                </div>

                <hr>

                <h4>Redemption Log</h4>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                        <tr>
                            <th>Status</th>
                            <th>Reason</th>
                            <th>User</th>
                            <th>Device</th>
                            <th>IP</th>
                            <th>Time</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $redemptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <?php echo $r->status === 'success'
                                        ? '<span class="label label-success">success</span>'
                                        : '<span class="label label-danger">failed</span>'; ?>

                                </td>
                                <td><?php echo e($r->fail_reason ?: '-'); ?></td>
                                <td><?php echo e($r->user_id ?: '-'); ?></td>
                                <td style="max-width:260px;word-break:break-all;"><?php echo e($r->device_id ?: '-'); ?></td>
                                <td><?php echo e($r->ip ?: '-'); ?></td>
                                <td><?php echo e($r->redeemed_at ? $r->redeemed_at->format('Y-m-d H:i') : '-'); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr><td colspan="6">No redemptions yet.</td></tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <?php echo e($redemptions->links()); ?>


            </div>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/okgroups/public_html/sm.okgroups.com/resources/views/settings/vouchers/show.blade.php ENDPATH**/ ?>