<div class="card">
    <h6 class="card-header"><?php echo app('translator')->get('General'); ?></h6>

    <div class="card-body">
        <form action="<?php echo e(route('settings.auth.update')); ?>" method="POST" id="registration-settings-form">
        <?php echo csrf_field(); ?>

        <div class="form-group mb-4">
            <div class="d-flex align-items-center">
                <div class="switch">
                    <input type="hidden" value="0" name="reg_enabled">

                    <input
                        type="checkbox" name="reg_enabled"
                        id="switch-reg-enabled"
                        class="switch" value="1"
                        <?php echo e(setting('reg_enabled') ? 'checked' : ''); ?>>

                    <label for="switch-reg-enabled"></label>
                </div>
                <div class="ml-3 d-flex flex-column">
                    <label class="mb-0"><?php echo app('translator')->get('Allow Registration'); ?></label>
                </div>
            </div>
        </div>

        <div class="form-group my-4">
            <div class="d-flex align-items-center">
                <div class="switch">
                    <input type="hidden" value="0" name="tos">
                    <input
                        value="1"
                        type="checkbox" name="tos"
                        id="switch-tos"
                        class="switch"
                        <?php echo e(setting('tos') ? 'checked' : ''); ?>>
                    <label for="switch-tos"></label>
                </div>
                <div class="ml-3 d-flex flex-column">
                    <label class="mb-0"><?php echo app('translator')->get('Terms & Conditions'); ?></label>
                    <small class="pt-0 text-muted">
                        <?php echo app('translator')->get('The user has to confirm that he agrees with terms and conditions in order to create an account.'); ?>
                    </small>
                </div>
            </div>
        </div>

        <div class="form-group my-4">
            <div class="d-flex align-items-center">
                <div class="switch">
                    <input type="hidden" value="0" name="reg_email_confirmation">
                    <input
                        value="1"
                        type="checkbox" name="reg_email_confirmation"
                        id="switch-reg-email-confirm"
                        class="switch"
                        <?php echo e(setting('reg_email_confirmation') ? 'checked' : ''); ?>>
                    <label for="switch-reg-email-confirm"></label>
                </div>
                <div class="ml-3 d-flex flex-column">
                    <label class="mb-0">
                        <?php echo app('translator')->get('Email Confirmation'); ?>
                    </label>
                    <small class="text-muted">
                        <?php echo app('translator')->get('Require email confirmation from your newly registered users.'); ?>
                    </small>
                </div>
            </div>
        </div>

        <button type="submit" class="btn btn-primary mt-3">
            <?php echo app('translator')->get('Update'); ?>
        </button>
    </form>
    </div>
</div>
<?php /**PATH /home/okgroups/public_html/sm.okgroups.com/resources/views/settings/partials/registration.blade.php ENDPATH**/ ?>