<?php
// File: /home/okgroups/public_html/sm.okgroups.com/resources/views/settings/vouchers/index.blade.php
?>



<?php $__env->startSection('page-title', 'Vouchers'); ?>
<?php $__env->startSection('page-heading', 'Vouchers'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12">

        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>

        <div class="panel panel-default">
            <div class="panel-heading">
                <div class="d-flex" style="display:flex;justify-content:space-between;align-items:center;">
                    <strong>Voucher List</strong>
                    <a href="<?php echo e(route('settings.vouchers.create')); ?>" class="btn btn-primary btn-sm">Create Voucher</a>
                </div>
            </div>

            <div class="panel-body">

                <form method="GET" action="<?php echo e(route('settings.vouchers.index')); ?>" class="form-inline" style="margin-bottom:15px;">
                    <div class="form-group" style="margin-right:10px;">
                        <input type="text" name="search" class="form-control input-sm" placeholder="Search code..."
                               value="<?php echo e(request('search')); ?>">
                    </div>

                    <div class="form-group" style="margin-right:10px;">
                        <select name="status" class="form-control input-sm">
                            <option value="">All</option>
                            <option value="active"  <?php if(request('status')==='active'): echo 'selected'; endif; ?>>Active</option>
                            <option value="inactive" <?php if(request('status')==='inactive'): echo 'selected'; endif; ?>>Inactive</option>
                            <option value="used" <?php if(request('status')==='used'): echo 'selected'; endif; ?>>Used</option>
                            <option value="expired" <?php if(request('status')==='expired'): echo 'selected'; endif; ?>>Expired</option>
                        </select>
                    </div>

                    <button class="btn btn-default btn-sm" type="submit">Filter</button>
                </form>

                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                        <tr>
                            <th>Code</th>
                            <th>Seconds</th>
                            <th>Uses</th>
                            <th>Active</th>
                            <th>Expires</th>
                            <th>Created</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $vouchers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <a href="<?php echo e(route('settings.vouchers.show', $v->id)); ?>"><strong><?php echo e($v->code); ?></strong></a>
                                </td>
                                <td><?php echo e(number_format($v->seconds)); ?></td>
                                <td><?php echo e($v->uses_count); ?> / <?php echo e($v->max_uses); ?></td>
                                <td><?php echo $v->is_active ? '<span class="label label-success">Yes</span>' : '<span class="label label-default">No</span>'; ?></td>
                                <td><?php echo e($v->expires_at ? $v->expires_at->format('Y-m-d H:i') : '-'); ?></td>
                                <td><?php echo e($v->created_at ? $v->created_at->format('Y-m-d H:i') : '-'); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr><td colspan="6">No vouchers found.</td></tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <?php echo e($vouchers->links()); ?>


            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/okgroups/public_html/sm.okgroups.com/resources/views/settings/vouchers/index.blade.php ENDPATH**/ ?>