<div class="card">
    <div class="card-body">
        <h5 class="card-title mb-1"><?php echo app('translator')->get('Force Password Change On Next Login'); ?></h5>

        <small class="text-muted d-block mb-4">
            <?php echo app('translator')->get('Force all the users created manually by admin to reset the password on their first log in to be able to use the application.'); ?>
        </small>

        <?php if(setting('password-change.enabled')): ?>
            <form method="POST" action="<?php echo e(route('settings.auth.password-change.disable')); ?>" id="auth-password-change-settings-form">
                <?php echo csrf_field(); ?>
                <button type="submit"
                        class="btn btn-danger"
                        data-toggle="loader"
                        data-loading-text="<?php echo app('translator')->get('Disabling...'); ?>">
                    <?php echo app('translator')->get('Disable'); ?>
                </button>
            </form>
        <?php else: ?>
            <form method="POST" action="<?php echo e(route('settings.auth.password-change.enable')); ?>" id="auth-password-change-settings-form">
                <?php echo csrf_field(); ?>
                <button type="submit"
                        class="btn btn-primary"
                        data-toggle="loader"
                        data-loading-text="<?php echo app('translator')->get('Enabling...'); ?>">
                    <?php echo app('translator')->get('Enable'); ?>
                </button>
            </form>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/okgroups/public_html/sm.okgroups.com/resources/views/settings/partials/password-change.blade.php ENDPATH**/ ?>