<?php
// File: /home/okgroups/public_html/sm.okgroups.com/resources/views/settings/vouchers/create.blade.php
?>



<?php $__env->startSection('page-title', 'Create Voucher'); ?>
<?php $__env->startSection('page-heading', 'Create Voucher'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-8">

        <div class="panel panel-default">
            <div class="panel-heading"><strong>Create Voucher</strong></div>
            <div class="panel-body">

                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul style="margin:0;padding-left:18px;">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($e); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form method="POST" action="<?php echo e(route('settings.vouchers.store')); ?>">
                    <?php echo csrf_field(); ?>

                    <div class="form-group">
                        <label>Code (optional)</label>
                        <input type="text" class="form-control" name="code" value="<?php echo e(old('code')); ?>" placeholder="Leave empty to auto-generate">
                    </div>

                    <div class="form-group">
                        <label>Seconds</label>
                        <input type="number" class="form-control" name="seconds" value="<?php echo e(old('seconds', 3600)); ?>" min="1" required>
                    </div>

                    <div class="form-group">
                        <label>Max Uses</label>
                        <input type="number" class="form-control" name="max_uses" value="<?php echo e(old('max_uses', 1)); ?>" min="1">
                    </div>

                    <div class="form-group">
                        <label>Price (optional)</label>
                        <input type="text" class="form-control" name="price" value="<?php echo e(old('price')); ?>" placeholder="e.g. 1.000">
                    </div>

                    <div class="form-group">
                        <label>Title (optional)</label>
                        <input type="text" class="form-control" name="title" value="<?php echo e(old('title')); ?>" placeholder="e.g. 1 hour voucher">
                    </div>

                    <div class="form-group">
                        <label>Expires At (optional)</label>
                        <input type="datetime-local" class="form-control" name="expires_at" value="<?php echo e(old('expires_at')); ?>">
                    </div>

                    <div class="checkbox">
                        <label>
                            <input type="checkbox" name="is_active" value="1" <?php echo e(old('is_active', '1') ? 'checked' : ''); ?>>
                            Active
                        </label>
                    </div>

                    <div style="margin-top:15px;">
                        <button class="btn btn-primary">Create</button>
                        <a href="<?php echo e(route('settings.vouchers.index')); ?>" class="btn btn-default">Back</a>
                    </div>

                </form>

            </div>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/okgroups/public_html/sm.okgroups.com/resources/views/settings/vouchers/create.blade.php ENDPATH**/ ?>