

<?php $__env->startSection('page-title', $user->present()->nameOrEmail); ?>
<?php $__env->startSection('page-heading', $user->present()->nameOrEmail); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item">
        <a href="<?php echo e(route('users.index')); ?>"><?php echo app('translator')->get('Users'); ?></a>
    </li>
    <li class="breadcrumb-item active">
        <?php echo e($user->present()->nameOrEmail); ?>

    </li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="row">
    <!-- ✅ Details Card - کم پهنا شده -->
    <div class="col-lg-3">
        <div class="card">
            <h6 class="card-header d-flex align-items-center justify-content-between">
                <?php echo app('translator')->get('Details'); ?>

                <small>
                    <?php if (can_be_impersonated($user, )) : ?>
                    <a href="<?php echo e(route('impersonate', $user)); ?>"
                       data-toggle="tooltip"
                       data-placement="top"
                       title="<?php echo app('translator')->get('Impersonate User'); ?>">
                        <?php echo app('translator')->get('Impersonate'); ?>
                    </a>
                    <span class="text-muted">|</span>
                    <?php endif; ?>

                    <a href="<?php echo e(route('users.edit', $user)); ?>"
                       class="edit"
                       data-toggle="tooltip"
                       data-placement="top"
                       title="<?php echo app('translator')->get('Edit User'); ?>">
                        <?php echo app('translator')->get('Edit'); ?>
                    </a>
                </small>
            </h6>
            <div class="card-body">
               <div class="d-flex align-items-center flex-column pt-3">
                    <div>
                        <img class="rounded-circle img-thumbnail img-responsive mb-4"
                             width="130"
                             height="130" src="<?php echo e($user->present()->avatar); ?>">
                    </div>

                    <?php if($name = $user->present()->name): ?>
                        <h5><?php echo e($user->present()->name); ?></h5>
                    <?php endif; ?>

                    <a href="mailto:<?php echo e($user->email); ?>" class="text-muted font-weight-light mb-2">
                        <?php echo e($user->email); ?>

                    </a>
                </div>

                <ul class="list-group list-group-flush mt-3">
                    <?php if($user->phone): ?>
                        <li class="list-group-item">
                            <strong><?php echo app('translator')->get('Phone'); ?>:</strong>
                            <a href="telto:<?php echo e($user->phone); ?>"><?php echo e($user->phone); ?></a>
                        </li>
                    <?php endif; ?>
                    <li class="list-group-item">
                        <strong><?php echo app('translator')->get('Birthday'); ?>:</strong>
                        <?php echo e($user->present()->birthday); ?>

                    </li>
                    <li class="list-group-item">
                        <strong><?php echo app('translator')->get('Address'); ?>:</strong>
                        <?php echo e($user->present()->fullAddress); ?>

                    </li>
                    <li class="list-group-item">
                        <strong><?php echo app('translator')->get('Last Logged In'); ?>:</strong>
                        <?php echo e($user->present()->lastLogin); ?>

                    </li>
                </ul>
            </div>
        </div>
    </div>

    <!-- ✅ Transactions - پهنای بیشتر -->
    <div class="col-lg-9">
        <div class="card">
            <h6 class="card-header">
                <?php echo app('translator')->get('Transactions'); ?>
            </h6>
            <div class="card-body">
                <!-- ✅ فیلتر بالای جدول -->
                <div class="row mb-3">
                    <div class="col-md-4">
                        <div class="btn-group" role="group">
                            <button type="button" 
                                    class="btn btn-sm btn-outline-secondary filter-btn active" 
                                    data-filter="all">
                                <?php echo app('translator')->get('All'); ?> (<?php echo e(count($purchases) + count($voucherRedemptions)); ?>)
                            </button>
                            <button type="button" 
                                    class="btn btn-sm btn-outline-secondary filter-btn" 
                                    data-filter="purchase">
                                <?php echo app('translator')->get('Purchases'); ?> (<?php echo e(count($purchases)); ?>)
                            </button>
                            <button type="button" 
                                    class="btn btn-sm btn-outline-secondary filter-btn" 
                                    data-filter="voucher">
                                <?php echo app('translator')->get('Vouchers'); ?> (<?php echo e(count($voucherRedemptions)); ?>)
                            </button>
                        </div>
                    </div>
                </div>

                <!-- ✅ جدول واحد -->
                <div class="table-responsive">
                    <?php
                        // Merge تراکنش‌ها
                        $transactions = collect();
                        
                        // اضافه کردن Purchases
                        foreach ($purchases as $purchase) {
                            $transactions->push([
                                'type' => 'purchase',
                                'type_label' => 'خرید',
                                'reference' => $purchase->product_id,
                                'seconds' => $purchase->seconds_added,
                                'price' => $purchase->price,
                                'currency' => $purchase->currency,
                                'status' => $purchase->status,
                                'date' => $purchase->purchased_at,
                                'details' => $purchase,
                            ]);
                        }
                        
                        // اضافه کردن Vouchers
                        foreach ($voucherRedemptions as $redemption) {
                            $transactions->push([
                                'type' => 'voucher',
                                'type_label' => 'کوپن',
                                'reference' => $redemption->code_snapshot,
                                'seconds' => $redemption->voucher?->seconds ?? 0,
                                'price' => null,
                                'currency' => null,
                                'status' => $redemption->status,
                                'date' => $redemption->redeemed_at,
                                'details' => $redemption,
                            ]);
                        }
                        
                        // مرتب کردن به تاریخ (جدیدترین اول)
                        $transactions = $transactions->sortByDesc('date');
                    ?>

                    <?php if($transactions->count() > 0): ?>
                        <table class="table table-striped table-borderless" id="transactions-table">
                            <thead style="background-color: #f8f9fa;">
                                <tr>
                                    <th style="font-weight: 600; color: #495057;"><?php echo app('translator')->get('Type'); ?></th>
                                    <th style="font-weight: 600; color: #495057;"><?php echo app('translator')->get('Reference'); ?></th>
                                    <th style="font-weight: 600; color: #495057;"><?php echo app('translator')->get('Seconds'); ?></th>
                                    <th style="font-weight: 600; color: #495057;"><?php echo app('translator')->get('Price'); ?></th>
                                    <th style="font-weight: 600; color: #495057;"><?php echo app('translator')->get('Status'); ?></th>
                                    <th style="font-weight: 600; color: #495057;"><?php echo app('translator')->get('Date'); ?></th>
                                    <th style="font-weight: 600; color: #495057; text-align: center;"><?php echo app('translator')->get('Details'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="transaction-row" data-type="<?php echo e($transaction['type']); ?>">
                                        <!-- ✅ نوع تراکنش -->
                                        <td>
                                            <?php if($transaction['type'] === 'purchase'): ?>
                                                <span class="badge badge-primary">🛒 <?php echo app('translator')->get('Purchase'); ?></span>
                                            <?php else: ?>
                                                <span class="badge badge-success">🎫 <?php echo app('translator')->get('Voucher'); ?></span>
                                            <?php endif; ?>
                                        </td>

                                        <!-- ✅ مرجع (Product ID یا Voucher Code) -->
                                        <td>
                                            <strong><?php echo e($transaction['reference']); ?></strong>
                                        </td>

                                        <!-- ✅ مقدار شارژ -->
                                        <td>
                                            <span class="badge badge-info">
                                                <?php echo e(gmdate('H:i:s', $transaction['seconds'])); ?>

                                            </span>
                                        </td>

                                        <!-- ✅ قیمت (فقط برای خریدها) -->
                                        <td>
                                            <?php if($transaction['price']): ?>
                                                <?php echo e(number_format($transaction['price'], 2)); ?> 
                                                <small><?php echo e($transaction['currency']); ?></small>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif; ?>
                                        </td>

                                        <!-- ✅ وضعیت -->
                                        <td>
                                            <?php if($transaction['status'] === 'success'): ?>
                                                <span class="badge badge-success">✓ <?php echo app('translator')->get('Success'); ?></span>
                                            <?php elseif($transaction['status'] === 'pending'): ?>
                                                <span class="badge badge-warning">⏳ <?php echo app('translator')->get('Pending'); ?></span>
                                            <?php else: ?>
                                                <span class="badge badge-danger">✗ <?php echo app('translator')->get('Failed'); ?></span>
                                            <?php endif; ?>
                                        </td>

                                        <!-- ✅ تاریخ با Timezone عمان +4 -->
                                        <td>
                                            <small><?php echo e($transaction['date']?->setTimezone('+04:00')->format('Y-m-d H:i') ?? '-'); ?></small>
                                        </td>

                                        <!-- ✅ دکمه چشم برای جزئیات -->
                                        <td style="text-align: center;">
                                            <button type="button" 
                                                    class="btn btn-sm btn-link view-details-btn"
                                                    data-toggle="modal"
                                                    data-target="#detailsModal"
                                                    data-transaction="<?php echo e(json_encode($transaction)); ?>"
                                                    title="<?php echo app('translator')->get('View Details'); ?>">
                                                <i class="fas fa-eye text-primary"></i>
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <div class="alert alert-info" role="alert">
                            <?php echo app('translator')->get('No transactions found.'); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- ✅ Modal جزئیات تراکنش - Modern Design -->
<div class="modal fade" id="detailsModal" tabindex="-1" role="dialog" aria-labelledby="detailsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content border-0 shadow-lg" style="border-radius: 12px;">
            <div class="modal-header border-bottom" style="background: linear-gradient(135deg, #27ae60 0%, #229954 100%); color: white;">
                <h5 class="modal-title" id="detailsModalLabel" style="font-weight: 600;"><?php echo app('translator')->get('Transaction Details'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color: white; opacity: 0.8;">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="modal-details-content" style="padding: 30px;">
                <!-- محتویات بر اساس نوع تراکنش قرار می‌گیرد -->
            </div>
            <div class="modal-footer border-top">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- ✅ Modal View Receipt -->
<div class="modal fade" id="receiptModal" tabindex="-1" role="dialog" aria-labelledby="receiptModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content border-0 shadow-lg" style="border-radius: 12px;">
            <div class="modal-header border-bottom" style="background: linear-gradient(135deg, #27ae60 0%, #229954 100%); color: white;">
                <h5 class="modal-title" id="receiptModalLabel"><?php echo app('translator')->get('Receipt Details'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color: white; opacity: 0.8;">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="receipt-content" style="padding: 30px; max-height: 600px; overflow-y: auto;">
                <!-- محتوی رسید JSON -->
            </div>
            <div class="modal-footer border-top">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // ✅ فیلتر کردن
    const filterButtons = document.querySelectorAll('.filter-btn');
    const transactionRows = document.querySelectorAll('.transaction-row');

    filterButtons.forEach(button => {
        button.addEventListener('click', function() {
            const filter = this.getAttribute('data-filter');

            filterButtons.forEach(btn => btn.classList.remove('active'));
            this.classList.add('active');

            transactionRows.forEach(row => {
                if (filter === 'all') {
                    row.style.display = '';
                } else {
                    row.style.display = row.getAttribute('data-type') === filter ? '' : 'none';
                }
            });
        });
    });

    // ✅ Modal جزئیات تراکنش
    const viewDetailsBtns = document.querySelectorAll('.view-details-btn');
    
    viewDetailsBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            const transactionData = JSON.parse(this.getAttribute('data-transaction'));
            const modalContent = document.getElementById('modal-details-content');
            const modalTitle = document.getElementById('detailsModalLabel');
            
            let html = '';

            if (transactionData.type === 'purchase') {
                const details = transactionData.details;
                const countryName = details.country ? details.country.name : 'N/A';
                
                html = `
                    <div class="transaction-details">
                        <!-- ✅ Transaction ID و Status -->
                        <div style="margin-bottom: 25px;">
                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                <div>
                                    <h6 style="color: #667eea; font-weight: 600; margin-bottom: 5px;"><?php echo app('translator')->get('Transaction ID'); ?></h6>
                                    <h3 style="margin: 0; color: #333;">#${details.id}</h3>
                                </div>
                                <div>
                                    ${getStatusBadge(details.status)}
                                </div>
                            </div>
                        </div>

                        <hr style="margin: 20px 0; border-color: #e9ecef;">

                        <!-- ✅ Basic Information -->
                        <div class="row">
                            <div class="col-md-6" style="margin-bottom: 20px;">
                                <h6 style="color: #667eea; font-weight: 600; font-size: 14px; margin-bottom: 15px; text-transform: uppercase;">🛒 <?php echo app('translator')->get('Purchase Information'); ?></h6>
                                
                                <div style="margin-bottom: 12px;">
                                    <small style="color: #6c757d; display: block;"><?php echo app('translator')->get('Product'); ?></small>
                                    <strong style="color: #333; font-size: 15px;">${details.product_id}</strong>
                                </div>

                                <div style="margin-bottom: 12px;">
                                    <small style="color: #6c757d; display: block;"><?php echo app('translator')->get('Seconds'); ?></small>
                                    <span class="badge badge-info" style="font-size: 13px; padding: 6px 10px;">
                                        ${formatSeconds(details.seconds_added)}
                                    </span>
                                </div>

                                <div style="margin-bottom: 12px;">
                                    <small style="color: #6c757d; display: block;"><?php echo app('translator')->get('Price'); ?></small>
                                    <strong style="color: #28a745; font-size: 15px;">${details.price ? (Math.round(details.price * 100) / 100).toFixed(2) + ' ' + details.currency : '-'}</strong>
                                </div>

                                <div style="margin-bottom: 12px;">
                                    <small style="color: #6c757d; display: block;"><?php echo app('translator')->get('Purchase Date'); ?></small>
                                    <strong style="color: #333; font-size: 14px;">${formatDateWithTimezone(details.purchased_at)}</strong>
                                </div>
                            </div>

                            <div class="col-md-6" style="margin-bottom: 20px;">
                                <h6 style="color: #667eea; font-weight: 600; font-size: 14px; margin-bottom: 15px; text-transform: uppercase;">🌐 <?php echo app('translator')->get('Device Information'); ?></h6>
                                
                                <div style="margin-bottom: 12px;">
                                    <small style="color: #6c757d; display: block;"><?php echo app('translator')->get('Device ID'); ?></small>
                                    <code style="background: #f8f9fa; padding: 6px 10px; border-radius: 4px; display: block; word-break: break-all; color: #333;">${details.device_id || '-'}</code>
                                </div>

                                <div style="margin-bottom: 12px;">
                                    <small style="color: #6c757d; display: block;"><?php echo app('translator')->get('IP Address'); ?></small>
                                    <code style="background: #f8f9fa; padding: 6px 10px; border-radius: 4px; color: #333;">${details.ip || '-'}</code>
                                </div>

                                <div style="margin-bottom: 12px;">
                                    <small style="color: #6c757d; display: block;"><?php echo app('translator')->get('Country'); ?></small>
                                    <strong style="color: #333; font-size: 14px;">🌍 ${countryName}</strong>
                                </div>
                            </div>
                        </div>

                        <hr style="margin: 20px 0; border-color: #e9ecef;">

                        <!-- ✅ Google Play Information -->
                        <div style="margin-bottom: 20px;">
                            <h6 style="color: #667eea; font-weight: 600; font-size: 14px; margin-bottom: 15px; text-transform: uppercase;">🔐 <?php echo app('translator')->get('Google Play Billing'); ?></h6>
                            
                            <div style="margin-bottom: 12px;">
                                <small style="color: #6c757d; display: block;"><?php echo app('translator')->get('Purchase Token'); ?></small>
                                <code style="background: #f8f9fa; padding: 10px; border-radius: 4px; display: block; word-break: break-all; font-size: 12px; color: #333; max-height: 80px; overflow-y: auto;">${details.purchase_token || '-'}</code>
                            </div>

                            <div style="margin-bottom: 12px;">
                                <small style="color: #6c757d; display: block;"><?php echo app('translator')->get('Receipt'); ?></small>
                                <button type="button" class="btn btn-success btn-sm view-receipt-btn" data-receipt='${details.receipt || ''}' style="margin-top: 5px;">
                                    <i class="fas fa-file-alt mr-2"></i> <?php echo app('translator')->get('View Receipt'); ?>
                                </button>
                            </div>
                        </div>
                    </div>
                `;
                modalTitle.textContent = '<?php echo app('translator')->get("Purchase Details"); ?> #' + details.id;
            } else {
                const details = transactionData.details;
                html = `
                    <div class="transaction-details">
                        <!-- ✅ Code و Status -->
                        <div style="margin-bottom: 25px;">
                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                <div>
                                    <h6 style="color: #667eea; font-weight: 600; margin-bottom: 5px;"><?php echo app('translator')->get('Voucher Code'); ?></h6>
                                    <h3 style="margin: 0; color: #333; font-family: monospace;">${details.code_snapshot}</h3>
                                </div>
                                <div>
                                    ${getStatusBadge(details.status)}
                                </div>
                            </div>
                        </div>

                        <hr style="margin: 20px 0; border-color: #e9ecef;">

                        <!-- ✅ Basic Information -->
                        <div class="row">
                            <div class="col-md-6" style="margin-bottom: 20px;">
                                <h6 style="color: #667eea; font-weight: 600; font-size: 14px; margin-bottom: 15px; text-transform: uppercase;">🎫 <?php echo app('translator')->get('Voucher Information'); ?></h6>
                                
                                <div style="margin-bottom: 12px;">
                                    <small style="color: #6c757d; display: block;"><?php echo app('translator')->get('Seconds'); ?></small>
                                    <span class="badge badge-info" style="font-size: 13px; padding: 6px 10px;">
                                        ${formatSeconds(transactionData.seconds)}
                                    </span>
                                </div>

                                <div style="margin-bottom: 12px;">
                                    <small style="color: #6c757d; display: block;"><?php echo app('translator')->get('Redeemed At'); ?></small>
                                    <strong style="color: #333; font-size: 14px;">${formatDateWithTimezone(details.redeemed_at)}</strong>
                                </div>
                            </div>

                            <div class="col-md-6" style="margin-bottom: 20px;">
                                <h6 style="color: #667eea; font-weight: 600; font-size: 14px; margin-bottom: 15px; text-transform: uppercase;">🌐 <?php echo app('translator')->get('Device Information'); ?></h6>
                                
                                <div style="margin-bottom: 12px;">
                                    <small style="color: #6c757d; display: block;"><?php echo app('translator')->get('Device ID'); ?></small>
                                    <code style="background: #f8f9fa; padding: 6px 10px; border-radius: 4px; display: block; word-break: break-all; color: #333;">${details.device_id || '-'}</code>
                                </div>

                                <div style="margin-bottom: 12px;">
                                    <small style="color: #6c757d; display: block;"><?php echo app('translator')->get('IP Address'); ?></small>
                                    <code style="background: #f8f9fa; padding: 6px 10px; border-radius: 4px; color: #333;">${details.ip || '-'}</code>
                                </div>
                            </div>
                        </div>
                    </div>
                `;
                modalTitle.textContent = '<?php echo app('translator')->get("Voucher Details"); ?> - ' + details.code_snapshot;
            }

            modalContent.innerHTML = html;
        });
    });

    // ✅ View Receipt Button
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('view-receipt-btn')) {
            const receiptData = e.target.getAttribute('data-receipt');
            
            if (!receiptData || receiptData.trim() === '') {
                alert('<?php echo app('translator')->get("No receipt data available"); ?>');
                return;
            }

            try {
                const receipt = JSON.parse(receiptData);
                const receiptContent = document.getElementById('receipt-content');
                
                let html = '<pre style="background: #f8f9fa; padding: 15px; border-radius: 6px; overflow-x: auto;">';
                html += JSON.stringify(receipt, null, 2);
                html += '</pre>';
                
                receiptContent.innerHTML = html;
                
                $('#receiptModal').modal('show');
            } catch (error) {
                // اگر JSON نبود، به صورت plain text نشان بده
                document.getElementById('receipt-content').innerHTML = 
                    '<pre style="background: #f8f9fa; padding: 15px; border-radius: 6px; word-break: break-all;">' + 
                    receiptData + 
                    '</pre>';
                
                $('#receiptModal').modal('show');
            }
        }
    });
});

// ✅ تابع فرمت کردن ثانیه‌ها
function formatSeconds(seconds) {
    const h = Math.floor(seconds / 3600);
    const m = Math.floor((seconds % 3600) / 60);
    const s = seconds % 60;
    return `${String(h).padStart(2, '0')}:${String(m).padStart(2, '0')}:${String(s).padStart(2, '0')}`;
}

// ✅ تابع نمایش Badge وضعیت
function getStatusBadge(status) {
    if (status === 'success') {
        return '<span class="badge badge-success" style="padding: 8px 12px; font-size: 13px;">✓ <?php echo app('translator')->get("Success"); ?></span>';
    } else if (status === 'pending') {
        return '<span class="badge badge-warning" style="padding: 8px 12px; font-size: 13px;">⏳ <?php echo app('translator')->get("Pending"); ?></span>';
    } else {
        return '<span class="badge badge-danger" style="padding: 8px 12px; font-size: 13px;">✗ <?php echo app('translator')->get("Failed"); ?></span>';
    }
}

// ✅ تابع فرمت تاریخ با Timezone عمان +4
function formatDateWithTimezone(dateString) {
    const date = new Date(dateString);
    
    // عمان UTC+4 = Asia/Dubai
    const formatter = new Intl.DateTimeFormat('en-US', {
        timeZone: 'Asia/Dubai',
        year: 'numeric',
        month: 'short',
        day: 'numeric',
        hour: '2-digit',
        minute: '2-digit',
        second: '2-digit',
        hour12: false
    });
    
    return formatter.format(date);
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/okgroups/public_html/sm.okgroups.com/resources/views/user/view.blade.php ENDPATH**/ ?>