



<?php $__env->startSection('page-title', __('App Contents')); ?>
<?php $__env->startSection('page-heading', __('App Contents')); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item text-muted"><?php echo app('translator')->get('Settings'); ?></li>
    <li class="breadcrumb-item active"><?php echo app('translator')->get('App Contents'); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('partials.messages', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="card">
    <div class="card-body">

        <p class="text-muted mb-3">
            <?php echo app('translator')->get('Select a key and edit the text in 19 languages.'); ?>
        </p>

        
        <form method="GET" action="<?php echo e(route('settings.app_contents.index')); ?>" class="mb-3">
            <div class="form-row align-items-end">
                <div class="col-md-6">
                    <label class="mb-1"><?php echo app('translator')->get('Content Key'); ?></label>
                    <select name="key" class="form-control" onchange="this.form.submit()">
                        <?php $__currentLoopData = $keys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($k); ?>" <?php echo e($selectedKey === $k ? 'selected' : ''); ?>>
                                <?php echo e($k); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-6 text-muted small">
                    <?php if($selectedKey === 'voucher_popup'): ?>
                        <div class="mt-2">
                            <strong class="text-danger">voucher_popup:</strong>
                            keep <code>{code}</code> in the body for all languages.
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </form>

        
        <form method="POST" action="<?php echo e(route('settings.app_contents.update')); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="key" value="<?php echo e($selectedKey); ?>">

            
            <div class="row mb-3">
                <div class="col-md-4">
                    <label class="mb-1">Format</label>
                    <input type="text" class="form-control" value="<?php echo e($meta['format'] ?? 'html'); ?>" disabled>
                    <input type="hidden" name="meta[format]" value="<?php echo e($meta['format'] ?? 'html'); ?>">
                </div>
                <div class="col-md-4">
                    <label class="mb-1">Active</label>
                    <input type="text" class="form-control" value="<?php echo e((int)($meta['is_active'] ?? 1)); ?>" disabled>
                    <input type="hidden" name="meta[is_active]" value="<?php echo e((int)($meta['is_active'] ?? 1)); ?>">
                </div>
                <div class="col-md-4">
                    <label class="mb-1">Verified</label>
                    <input type="text" class="form-control" value="<?php echo e((int)($meta['is_verified'] ?? 1)); ?>" disabled>
                    <input type="hidden" name="meta[is_verified]" value="<?php echo e((int)($meta['is_verified'] ?? 1)); ?>">
                </div>
            </div>

            
            <ul class="nav nav-tabs mb-3" role="tablist">
                <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $l): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e($i === 0 ? 'active' : ''); ?>"
                           id="tab-<?php echo e($l['code']); ?>"
                           data-toggle="tab"
                           href="#pane-<?php echo e($l['code']); ?>"
                           role="tab">
                            <?php echo e($l['name']); ?> <small class="text-muted">(<?php echo e($l['code']); ?>)</small>
                        </a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>

            <div class="tab-content">
                <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $l): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $lc = $l['code']; ?>
                    <div class="tab-pane fade <?php echo e($i === 0 ? 'show active' : ''); ?>"
                         id="pane-<?php echo e($lc); ?>"
                         role="tabpanel">

                        <div class="form-group">
                            <label><?php echo app('translator')->get('Title'); ?> (<?php echo e($lc); ?>)</label>
                            <input type="text"
                                   class="form-control"
                                   name="items[<?php echo e($lc); ?>][title]"
                                   value="<?php echo e(old("items.$lc.title", $items[$lc]['title'] ?? '')); ?>">
                            <?php $__errorArgs = ["items.$lc.title"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group">
                            <label><?php echo app('translator')->get('Body'); ?> (<?php echo e($lc); ?>)</label>
                            <textarea class="form-control"
                                      name="items[<?php echo e($lc); ?>][body]"
                                      rows="14"><?php echo e(old("items.$lc.body", $items[$lc]['body'] ?? '')); ?></textarea>

                            <?php if($selectedKey === 'voucher_popup'): ?>
                                <small class="text-muted">Must include <code>{code}</code></small>
                            <?php endif; ?>

                            <?php $__errorArgs = ["items.$lc.body"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="mt-3">
                <button class="btn btn-primary" type="submit">
                    <i class="fa fa-save"></i> <?php echo app('translator')->get('Save'); ?>
                </button>
            </div>

        </form>

    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/okgroups/public_html/sm.okgroups.com/resources/views/settings/app_contents.blade.php ENDPATH**/ ?>