<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudHealthcare;

class ListDicomStoresResponse extends \Google\Collection
{
  protected $collection_key = 'dicomStores';
  protected $dicomStoresType = DicomStore::class;
  protected $dicomStoresDataType = 'array';
  /**
   * Token to retrieve the next page of results or empty if there are no more
   * results in the list.
   *
   * @var string
   */
  public $nextPageToken;

  /**
   * The returned DICOM stores. Won't be more DICOM stores than the value of
   * page_size in the request.
   *
   * @param DicomStore[] $dicomStores
   */
  public function setDicomStores($dicomStores)
  {
    $this->dicomStores = $dicomStores;
  }
  /**
   * @return DicomStore[]
   */
  public function getDicomStores()
  {
    return $this->dicomStores;
  }
  /**
   * Token to retrieve the next page of results or empty if there are no more
   * results in the list.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ListDicomStoresResponse::class, 'Google_Service_CloudHealthcare_ListDicomStoresResponse');
