<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contactcenterinsights;

class GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageSystemMessageTextOutput extends \Google\Collection
{
  /**
   * The default text type.
   */
  public const TYPE_TYPE_UNSPECIFIED = 'TYPE_UNSPECIFIED';
  /**
   * The text is a thinking plan generated by the thinking tool.
   */
  public const TYPE_THOUGHT = 'THOUGHT';
  /**
   * The text is a final response to the user question.
   */
  public const TYPE_FINAL_RESPONSE = 'FINAL_RESPONSE';
  /**
   * The text is an informational message about the agent's progress, such as a
   * tool being invoked. This is distinct from the agent's internal thought
   * process (`THOUGHT`) and the final answer to the user (`FINAL_RESPONSE`).
   * These messages provide insight into the agent's actions.
   */
  public const TYPE_PROGRESS = 'PROGRESS';
  protected $collection_key = 'texts';
  /**
   * The parts of the message.
   *
   * @var string[]
   */
  public $texts;
  /**
   * The type of the text message.
   *
   * @var string
   */
  public $type;

  /**
   * The parts of the message.
   *
   * @param string[] $texts
   */
  public function setTexts($texts)
  {
    $this->texts = $texts;
  }
  /**
   * @return string[]
   */
  public function getTexts()
  {
    return $this->texts;
  }
  /**
   * The type of the text message.
   *
   * Accepted values: TYPE_UNSPECIFIED, THOUGHT, FINAL_RESPONSE, PROGRESS
   *
   * @param self::TYPE_* $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return self::TYPE_*
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageSystemMessageTextOutput::class, 'Google_Service_Contactcenterinsights_GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageSystemMessageTextOutput');
