<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CustomerEngagementSuite;

class RetrieveToolSchemaResponse extends \Google\Model
{
  protected $inputSchemaType = Schema::class;
  protected $inputSchemaDataType = '';
  protected $outputSchemaType = Schema::class;
  protected $outputSchemaDataType = '';
  /**
   * The name of the tool that the schema is for. Format:
   * `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
   *
   * @var string
   */
  public $tool;
  protected $toolsetToolType = ToolsetTool::class;
  protected $toolsetToolDataType = '';

  /**
   * Required. The schema of the tool input parameters.
   *
   * @param Schema $inputSchema
   */
  public function setInputSchema(Schema $inputSchema)
  {
    $this->inputSchema = $inputSchema;
  }
  /**
   * @return Schema
   */
  public function getInputSchema()
  {
    return $this->inputSchema;
  }
  /**
   * Required. The schema of the tool output parameters.
   *
   * @param Schema $outputSchema
   */
  public function setOutputSchema(Schema $outputSchema)
  {
    $this->outputSchema = $outputSchema;
  }
  /**
   * @return Schema
   */
  public function getOutputSchema()
  {
    return $this->outputSchema;
  }
  /**
   * The name of the tool that the schema is for. Format:
   * `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
   *
   * @param string $tool
   */
  public function setTool($tool)
  {
    $this->tool = $tool;
  }
  /**
   * @return string
   */
  public function getTool()
  {
    return $this->tool;
  }
  /**
   * The toolset tool that the schema is for.
   *
   * @param ToolsetTool $toolsetTool
   */
  public function setToolsetTool(ToolsetTool $toolsetTool)
  {
    $this->toolsetTool = $toolsetTool;
  }
  /**
   * @return ToolsetTool
   */
  public function getToolsetTool()
  {
    return $this->toolsetTool;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(RetrieveToolSchemaResponse::class, 'Google_Service_CustomerEngagementSuite_RetrieveToolSchemaResponse');
