<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Datastream;

class OracleTable extends \Google\Collection
{
  protected $collection_key = 'oracleColumns';
  protected $oracleColumnsType = OracleColumn::class;
  protected $oracleColumnsDataType = 'array';
  /**
   * The table name.
   *
   * @var string
   */
  public $table;

  /**
   * Oracle columns in the schema. When unspecified as part of include/exclude
   * objects, includes/excludes everything.
   *
   * @param OracleColumn[] $oracleColumns
   */
  public function setOracleColumns($oracleColumns)
  {
    $this->oracleColumns = $oracleColumns;
  }
  /**
   * @return OracleColumn[]
   */
  public function getOracleColumns()
  {
    return $this->oracleColumns;
  }
  /**
   * The table name.
   *
   * @param string $table
   */
  public function setTable($table)
  {
    $this->table = $table;
  }
  /**
   * @return string
   */
  public function getTable()
  {
    return $this->table;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(OracleTable::class, 'Google_Service_Datastream_OracleTable');
