<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Directory;

class ChromeOsDeviceLastKnownNetwork extends \Google\Model
{
  /**
   * The IP address.
   *
   * @var string
   */
  public $ipAddress;
  /**
   * The WAN IP address.
   *
   * @var string
   */
  public $wanIpAddress;

  /**
   * The IP address.
   *
   * @param string $ipAddress
   */
  public function setIpAddress($ipAddress)
  {
    $this->ipAddress = $ipAddress;
  }
  /**
   * @return string
   */
  public function getIpAddress()
  {
    return $this->ipAddress;
  }
  /**
   * The WAN IP address.
   *
   * @param string $wanIpAddress
   */
  public function setWanIpAddress($wanIpAddress)
  {
    $this->wanIpAddress = $wanIpAddress;
  }
  /**
   * @return string
   */
  public function getWanIpAddress()
  {
    return $this->wanIpAddress;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ChromeOsDeviceLastKnownNetwork::class, 'Google_Service_Directory_ChromeOsDeviceLastKnownNetwork');
