<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ThreatIntelligenceService;

class VulnerabilityMatch extends \Google\Collection
{
  /**
   * Unspecified exploitation state.
   */
  public const EXPLOITATION_STATE_EXPLOITATION_STATE_UNSPECIFIED = 'EXPLOITATION_STATE_UNSPECIFIED';
  /**
   * No known exploitation.
   */
  public const EXPLOITATION_STATE_EXPLOITATION_STATE_NO_KNOWN = 'EXPLOITATION_STATE_NO_KNOWN';
  /**
   * Exploitation has been reported.
   */
  public const EXPLOITATION_STATE_EXPLOITATION_STATE_REPORTED = 'EXPLOITATION_STATE_REPORTED';
  /**
   * Exploitation is suspected.
   */
  public const EXPLOITATION_STATE_EXPLOITATION_STATE_SUSPECTED = 'EXPLOITATION_STATE_SUSPECTED';
  /**
   * Exploitation is confirmed.
   */
  public const EXPLOITATION_STATE_EXPLOITATION_STATE_CONFIRMED = 'EXPLOITATION_STATE_CONFIRMED';
  /**
   * Widespread exploitation.
   */
  public const EXPLOITATION_STATE_EXPLOITATION_STATE_WIDESPREAD = 'EXPLOITATION_STATE_WIDESPREAD';
  /**
   * Unspecified risk rating. This is the default value when the risk rating is
   * not set.
   */
  public const RISK_RATING_RISK_RATING_UNSPECIFIED = 'RISK_RATING_UNSPECIFIED';
  /**
   * Low risk rating.
   */
  public const RISK_RATING_LOW = 'LOW';
  /**
   * Medium risk rating.
   */
  public const RISK_RATING_MEDIUM = 'MEDIUM';
  /**
   * High risk rating.
   */
  public const RISK_RATING_HIGH = 'HIGH';
  /**
   * Critical risk rating.
   */
  public const RISK_RATING_CRITICAL = 'CRITICAL';
  /**
   * The vulnerability has been assessed, but a specific risk rating could not
   * be determined or assigned.
   */
  public const RISK_RATING_UNRATED = 'UNRATED';
  protected $collection_key = 'technologies';
  protected $associationsType = Association::class;
  protected $associationsDataType = 'array';
  /**
   * Required. The collection ID of the vulnerability. Ex: "vulnerability--
   * cve-2025-9876".
   *
   * @var string
   */
  public $collectionId;
  /**
   * Required. The CVE ID of the vulnerability. Ex: "CVE-2025-9876". See
   * https://www.cve.org/ for more information.
   *
   * @var string
   */
  public $cveId;
  /**
   * Required. The CVSS v3 score of the vulnerability. Example: 6.4.
   *
   * @var float
   */
  public $cvss3Score;
  /**
   * Required. A description of the vulnerability.
   *
   * @var string
   */
  public $description;
  /**
   * Required. The exploitation state of the vulnerability.
   *
   * @var string
   */
  public $exploitationState;
  /**
   * Required. The risk rating of the vulnerability.
   *
   * @var string
   */
  public $riskRating;
  /**
   * Required. The affected technologies. Ex: "Apache Struts".
   *
   * @var string[]
   */
  public $technologies;

  /**
   * Optional. Associated threat actors, malware, etc. This is embedded as a
   * snapshot because the details of the association at the time of the
   * vulnerability match are important for context and reporting.
   *
   * @param Association[] $associations
   */
  public function setAssociations($associations)
  {
    $this->associations = $associations;
  }
  /**
   * @return Association[]
   */
  public function getAssociations()
  {
    return $this->associations;
  }
  /**
   * Required. The collection ID of the vulnerability. Ex: "vulnerability--
   * cve-2025-9876".
   *
   * @param string $collectionId
   */
  public function setCollectionId($collectionId)
  {
    $this->collectionId = $collectionId;
  }
  /**
   * @return string
   */
  public function getCollectionId()
  {
    return $this->collectionId;
  }
  /**
   * Required. The CVE ID of the vulnerability. Ex: "CVE-2025-9876". See
   * https://www.cve.org/ for more information.
   *
   * @param string $cveId
   */
  public function setCveId($cveId)
  {
    $this->cveId = $cveId;
  }
  /**
   * @return string
   */
  public function getCveId()
  {
    return $this->cveId;
  }
  /**
   * Required. The CVSS v3 score of the vulnerability. Example: 6.4.
   *
   * @param float $cvss3Score
   */
  public function setCvss3Score($cvss3Score)
  {
    $this->cvss3Score = $cvss3Score;
  }
  /**
   * @return float
   */
  public function getCvss3Score()
  {
    return $this->cvss3Score;
  }
  /**
   * Required. A description of the vulnerability.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Required. The exploitation state of the vulnerability.
   *
   * Accepted values: EXPLOITATION_STATE_UNSPECIFIED,
   * EXPLOITATION_STATE_NO_KNOWN, EXPLOITATION_STATE_REPORTED,
   * EXPLOITATION_STATE_SUSPECTED, EXPLOITATION_STATE_CONFIRMED,
   * EXPLOITATION_STATE_WIDESPREAD
   *
   * @param self::EXPLOITATION_STATE_* $exploitationState
   */
  public function setExploitationState($exploitationState)
  {
    $this->exploitationState = $exploitationState;
  }
  /**
   * @return self::EXPLOITATION_STATE_*
   */
  public function getExploitationState()
  {
    return $this->exploitationState;
  }
  /**
   * Required. The risk rating of the vulnerability.
   *
   * Accepted values: RISK_RATING_UNSPECIFIED, LOW, MEDIUM, HIGH, CRITICAL,
   * UNRATED
   *
   * @param self::RISK_RATING_* $riskRating
   */
  public function setRiskRating($riskRating)
  {
    $this->riskRating = $riskRating;
  }
  /**
   * @return self::RISK_RATING_*
   */
  public function getRiskRating()
  {
    return $this->riskRating;
  }
  /**
   * Required. The affected technologies. Ex: "Apache Struts".
   *
   * @param string[] $technologies
   */
  public function setTechnologies($technologies)
  {
    $this->technologies = $technologies;
  }
  /**
   * @return string[]
   */
  public function getTechnologies()
  {
    return $this->technologies;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VulnerabilityMatch::class, 'Google_Service_ThreatIntelligenceService_VulnerabilityMatch');
